/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.syntax.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import com.github.fge.jsonschema.keyword.syntax.helpers.SchemaMapSyntaxChecker;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.JacksonUtils;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;

public final class DraftV3PropertiesSyntaxChecker
extends SchemaMapSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new DraftV3PropertiesSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private DraftV3PropertiesSyntaxChecker() {
        super("properties");
    }

    @Override
    protected void extraChecks(ProcessingReport report, SchemaTree tree) throws ProcessingException {
        TreeMap map = Maps.newTreeMap();
        map.putAll(JacksonUtils.asMap((JsonNode)tree.getNode().get(this.keyword)));
        for (Map.Entry entry : map.entrySet()) {
            NodeType type;
            String member = (String)entry.getKey();
            JsonNode required = ((JsonNode)entry.getValue()).get("required");
            if (required == null || (type = NodeType.getNodeType((JsonNode)required)) == NodeType.BOOLEAN) continue;
            report.error(this.newMsg(tree, SyntaxMessages.DRAFTV3_PROPERTIES_REQUIRED).put("property", member).put("expected", (Object)NodeType.BOOLEAN).put("found", (Object)type));
        }
    }
}

