/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.ValidationData;
import com.github.fge.jsonschema.report.MessageProvider;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;

public final class ExtendsValidator
extends AbstractKeywordValidator {
    public ExtendsValidator(JsonNode digest) {
        super("extends");
    }

    @Override
    public void validate(Processor<ValidationData, ProcessingReport> processor, ProcessingReport report, ValidationData data) throws ProcessingException {
        SchemaTree tree = data.getSchema();
        JsonNode node = tree.getNode().get(this.keyword);
        if (node.isObject()) {
            ValidationData newData = data.withSchema(tree.append(JsonPointer.of((Object)this.keyword, (Object[])new Object[0])));
            processor.process(report, (MessageProvider)newData);
            return;
        }
        int size = node.size();
        for (int index = 0; index < size; ++index) {
            JsonPointer pointer = JsonPointer.of((Object)this.keyword, (Object[])new Object[]{index});
            ValidationData newData = data.withSchema(tree.append(pointer));
            processor.process(report, (MessageProvider)newData);
        }
    }

    @Override
    public String toString() {
        return this.keyword;
    }
}

