/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processing;

import com.github.fge.jsonschema.processing.LogThreshold;
import com.github.fge.jsonschema.processing.ProcessingException;
import com.github.fge.jsonschema.processing.ProcessingMessage;
import com.google.common.annotations.VisibleForTesting;

public abstract class ProcessingContext<T> {
    protected LogThreshold currentThreshold = LogThreshold.DEBUG;
    protected LogThreshold logThreshold = LogThreshold.INFO;
    protected LogThreshold exceptionThreshold = LogThreshold.FATAL;

    public final void setLogThreshold(LogThreshold threshold) {
        this.logThreshold = threshold;
    }

    public final void setExceptionThreshold(LogThreshold threshold) {
        this.exceptionThreshold = threshold;
    }

    public final void debug(ProcessingMessage msg) throws ProcessingException {
        this.doLog(LogThreshold.DEBUG, msg);
    }

    public final void info(ProcessingMessage msg) throws ProcessingException {
        this.doLog(LogThreshold.INFO, msg);
    }

    public final void warn(ProcessingMessage msg) throws ProcessingException {
        this.doLog(LogThreshold.WARNING, msg);
    }

    public final void error(ProcessingMessage msg) throws ProcessingException {
        this.doLog(LogThreshold.ERROR, msg);
    }

    public final void fatal(ProcessingMessage msg) throws ProcessingException {
        this.doLog(LogThreshold.FATAL, msg);
    }

    public final boolean isSuccess() {
        return this.currentThreshold.compareTo(LogThreshold.ERROR) < 0;
    }

    public abstract void log(ProcessingMessage var1);

    public abstract ProcessingException buildException(ProcessingMessage var1);

    @VisibleForTesting
    final void doLog(LogThreshold threshold, ProcessingMessage msg) throws ProcessingException {
        if (threshold.compareTo(this.exceptionThreshold) >= 0) {
            throw this.buildException(msg);
        }
        if (threshold.compareTo(this.currentThreshold) > 0) {
            this.currentThreshold = threshold;
        }
        if (threshold.compareTo(this.logThreshold) >= 0) {
            this.log(msg.setLogThreshold(threshold));
        }
    }

    public abstract ProcessingMessage newMessage();

    public abstract T getOutput();
}

