/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.processing.ref.Dereferencing;
import com.github.fge.jsonschema.ref.JsonPointer;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.tree.JsonSchemaTree;
import com.github.fge.jsonschema.util.jackson.JacksonUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public final class InlineSchemaTree
extends JsonSchemaTree {
    private final Map<JsonRef, JsonPointer> ptrRefs;
    private final Map<JsonRef, JsonPointer> otherRefs;

    public InlineSchemaTree(JsonRef loadingRef, JsonNode baseNode) {
        super(loadingRef, baseNode, Dereferencing.INLINE);
        HashMap ptrMap = Maps.newHashMap();
        HashMap otherMap = Maps.newHashMap();
        InlineSchemaTree.walk(this.currentRef, this.currentNode, JsonPointer.empty(), ptrMap, otherMap);
        this.ptrRefs = ImmutableMap.copyOf((Map)ptrMap);
        this.otherRefs = ImmutableMap.copyOf((Map)otherMap);
    }

    public InlineSchemaTree(JsonNode baseNode) {
        this(JsonRef.emptyRef(), baseNode);
    }

    @Override
    public boolean containsRef(JsonRef ref) {
        return this.getMatchingPointer(ref) != null;
    }

    @Override
    public JsonPointer matchingPointer(JsonRef ref) {
        JsonPointer ret = this.getMatchingPointer(ref);
        if (ret == null) {
            return null;
        }
        return ret.resolve(this.baseNode).isMissingNode() ? null : ret;
    }

    private JsonPointer getMatchingPointer(JsonRef ref) {
        return ref.getFragment().isPointer() ? this.refMatchingPointer(ref) : this.otherMatchingPointer(ref);
    }

    private JsonPointer refMatchingPointer(JsonRef ref) {
        JsonPointer refPtr = (JsonPointer)ref.getFragment();
        if (this.loadingRef.contains(ref)) {
            return refPtr;
        }
        for (Map.Entry<JsonRef, JsonPointer> entry : this.ptrRefs.entrySet()) {
            JsonPointer inlinePtr;
            JsonRef inlineRef = entry.getKey();
            if (!entry.getKey().contains(ref) || !(inlinePtr = (JsonPointer)inlineRef.getFragment()).isParentOf(refPtr)) continue;
            return entry.getValue().append(inlinePtr.relativize(refPtr));
        }
        return null;
    }

    private JsonPointer otherMatchingPointer(JsonRef ref) {
        return this.otherRefs.get(ref);
    }

    private static void walk(JsonRef baseRef, JsonNode node, JsonPointer ptr, Map<JsonRef, JsonPointer> ptrMap, Map<JsonRef, JsonPointer> otherMap) {
        if (!node.isObject()) {
            return;
        }
        JsonRef ref = InlineSchemaTree.idFromNode(node);
        JsonRef nextRef = baseRef;
        if (ref != null) {
            nextRef = baseRef.resolve(ref);
            Map<JsonRef, JsonPointer> targetMap = nextRef.getFragment().isPointer() ? ptrMap : otherMap;
            targetMap.put(nextRef, ptr);
        }
        Map<String, JsonNode> tmp = JacksonUtils.asMap(node);
        for (Map.Entry<String, JsonNode> entry : tmp.entrySet()) {
            InlineSchemaTree.walk(nextRef, entry.getValue(), ptr.append(entry.getKey()), ptrMap, otherMap);
        }
    }
}

