/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.main.JsonSchemaException;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.Domain;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.schema.SchemaContainer;
import com.github.fge.jsonschema.schema.SchemaNode;
import com.github.fge.jsonschema.schema.SchemaRegistry;
import java.util.LinkedHashSet;

final class JsonResolver {
    private final SchemaRegistry registry;

    JsonResolver(SchemaRegistry registry) {
        this.registry = registry;
    }

    SchemaNode resolve(SchemaNode schemaNode) throws JsonSchemaException {
        JsonNode refNode;
        Message.Builder msg = Domain.REF_RESOLVING.newMessage().setKeyword("$ref").setFatal(true);
        SchemaContainer container = schemaNode.getContainer();
        JsonNode node = schemaNode.getNode();
        LinkedHashSet<JsonRef> refs = new LinkedHashSet<JsonRef>();
        while ((refNode = node.path("$ref")).isTextual()) {
            JsonRef ref;
            try {
                ref = JsonRef.fromString(refNode.textValue());
            }
            catch (JsonSchemaException ignored) {
                break;
            }
            JsonRef source = container.getLocator();
            JsonRef target = source.resolve(ref);
            if (!refs.add(target)) {
                msg.setMessage("ref loop detected").addInfo("path", refs);
                throw new JsonSchemaException(msg.build());
            }
            if (!container.contains(target)) {
                container = this.registry.get(target.getLocator());
            }
            if (!(node = container.resolve(target)).isMissingNode()) continue;
            msg.setMessage("dangling JSON Reference").addInfo("ref", target);
            throw new JsonSchemaException(msg.build());
        }
        return new SchemaNode(container, node);
    }
}

