/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxValidator;
import com.github.fge.jsonschema.util.NodeType;
import java.math.BigDecimal;
import java.util.List;

public final class DivisorSyntaxChecker
extends AbstractSyntaxChecker {
    public DivisorSyntaxChecker(String keyword) {
        super(keyword, NodeType.INTEGER, NodeType.NUMBER);
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (node.decimalValue().compareTo(BigDecimal.ZERO) > 0) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo("value", node).setMessage(this.keyword + " is not strictly greater than 0");
        messages.add(msg.build());
    }
}

