/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.keyword.KeywordValidator;
import com.github.fge.jsonschema.metaschema.MetaSchema;
import com.github.fge.jsonschema.report.Domain;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.validator.ValidationContext;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class KeywordFactory {
    private final Map<String, Class<? extends KeywordValidator>> validators;

    public KeywordFactory(MetaSchema metaSchema) {
        this.validators = metaSchema.getValidators();
    }

    public Set<KeywordValidator> getValidators(JsonNode schema) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        HashSet set = Sets.newHashSet((Iterator)schema.fieldNames());
        set.retainAll(this.validators.keySet());
        for (String keyword : set) {
            KeywordValidator validator = KeywordFactory.buildValidator(this.validators.get(keyword), schema);
            if (validator.alwaysTrue()) continue;
            builder.add((Object)validator);
        }
        return builder.build();
    }

    private static KeywordValidator buildValidator(Class<? extends KeywordValidator> c, JsonNode schema) {
        Constructor<? extends KeywordValidator> constructor;
        try {
            constructor = c.getConstructor(JsonNode.class);
        }
        catch (NoSuchMethodException e) {
            return KeywordFactory.invalidValidator(c, e);
        }
        try {
            return constructor.newInstance(schema);
        }
        catch (InstantiationException e) {
            return KeywordFactory.invalidValidator(c, e);
        }
        catch (IllegalAccessException e) {
            return KeywordFactory.invalidValidator(c, e);
        }
        catch (InvocationTargetException e) {
            return KeywordFactory.invalidValidator(c, e);
        }
    }

    private static KeywordValidator invalidValidator(Class<? extends KeywordValidator> c, final Exception e) {
        final String className = c.getName();
        return new KeywordValidator(className, NodeType.values()){

            @Override
            protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
                Message.Builder msg = Domain.VALIDATION.newMessage().setMessage("cannot build validator").setKeyword(className).addInfo("exception", e.getClass().getName()).addInfo("exceptionMessage", e.getMessage()).setFatal(true);
                report.addMessage(msg.build());
            }

            @Override
            public String toString() {
                return className;
            }
        };
    }
}

