/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.net.InternetDomainName;

public final class HostnameFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute INSTANCE = new HostnameFormatAttribute();

    private HostnameFormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        try {
            InternetDomainName.from((String)value.textValue());
        }
        catch (IllegalArgumentException ignored) {
            Message.Builder msg = HostnameFormatAttribute.newMsg(fmt).setMessage("string is not a valid hostname").addInfo("value", value);
            report.addMessage(msg.build());
        }
    }
}

