/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.main.JsonSchemaException;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.schema.SchemaContainer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public final class InlineSchemaContainer
extends SchemaContainer {
    private final Map<JsonRef, JsonNode> schemas;

    InlineSchemaContainer(JsonNode schema) {
        super(InlineSchemaContainer.extractLocator(schema).toURI(), schema);
        HashMap map = Maps.newHashMap();
        map.put(this.locator, this.schema);
        InlineSchemaContainer.fillURIMap(this.locator, this.schema, map);
        this.schemas = ImmutableMap.copyOf((Map)map);
    }

    @Override
    public boolean contains(JsonRef other) {
        return this.schemas.containsKey(other) || this.locator.contains(other);
    }

    @Override
    public JsonNode resolve(JsonRef ref) {
        return this.schemas.containsKey(ref) ? this.schemas.get(ref) : ref.getFragment().resolve(this.schema);
    }

    private static JsonRef extractLocator(JsonNode node) {
        try {
            return InlineSchemaContainer.refFromNode(node.path("id"));
        }
        catch (JsonSchemaException ignored) {
            return JsonRef.emptyRef();
        }
    }

    private static void fillURIMap(JsonRef baseRef, JsonNode node, Map<JsonRef, JsonNode> map) {
        if (!node.isObject()) {
            return;
        }
        for (JsonNode child : node) {
            if (child.has("id")) {
                try {
                    JsonRef idRef = InlineSchemaContainer.refFromNode(child.get("id"));
                    JsonRef resolvedRef = baseRef.resolve(idRef);
                    map.put(resolvedRef, InlineSchemaContainer.cleanup(child));
                }
                catch (JsonSchemaException ignored) {
                    // empty catch block
                }
            }
            InlineSchemaContainer.fillURIMap(baseRef, InlineSchemaContainer.cleanup(child), map);
        }
    }

    private static JsonRef refFromNode(JsonNode node) throws JsonSchemaException {
        return node.isTextual() ? JsonRef.fromString(node.textValue()) : JsonRef.emptyRef();
    }
}

