/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.main.JsonSchemaException;
import com.github.fge.jsonschema.ref.IllegalFragment;
import com.github.fge.jsonschema.ref.JsonPointer;

public abstract class JsonFragment
implements Comparable<JsonFragment> {
    private static final JsonFragment EMPTY = new JsonFragment(""){

        @Override
        public JsonNode resolve(JsonNode node) {
            return node;
        }
    };
    protected final String asString;

    protected JsonFragment(String input) {
        this.asString = input;
    }

    public static JsonFragment fromFragment(String fragment) {
        if (fragment.isEmpty()) {
            return EMPTY;
        }
        try {
            return new JsonPointer(fragment);
        }
        catch (JsonSchemaException ignored) {
            return new IllegalFragment(fragment);
        }
    }

    public abstract JsonNode resolve(JsonNode var1);

    public final boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public final int compareTo(JsonFragment o) {
        return this.asString.compareTo(o.asString);
    }

    public final int hashCode() {
        return this.asString.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonFragment)) {
            return false;
        }
        JsonFragment other = (JsonFragment)obj;
        return this.asString.equals(other.asString);
    }

    public final String toString() {
        return this.asString;
    }
}

