/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class DraftV4DependenciesKeywordValidator
extends KeywordValidator {
    private final Map<String, JsonNode> schemaDeps = Maps.newHashMap();
    private final Map<String, Set<String>> propertyDeps = Maps.newHashMap();

    public DraftV4DependenciesKeywordValidator(JsonNode schema) {
        super("dependencies", NodeType.OBJECT);
        Map<String, JsonNode> map = ((ObjectNode)schema.get(this.keyword)).asMap();
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            String key = entry.getKey();
            JsonNode value = entry.getValue();
            if (value.isObject()) {
                this.schemaDeps.put(key, value);
                continue;
            }
            HashSet set = Sets.newHashSet();
            for (JsonNode node : value) {
                set.add(node.textValue());
            }
            this.propertyDeps.put(key, set);
        }
    }

    @Override
    protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (!this.schemaDeps.isEmpty()) {
            this.processSchemaDeps(context, report, instance);
        }
        if (!this.propertyDeps.isEmpty()) {
            this.processPropertyDeps(report, instance);
        }
    }

    private void processSchemaDeps(ValidationContext context, ValidationReport report, JsonNode instance) {
        HashSet fields = Sets.newHashSet((Iterator)instance.fieldNames());
        TreeSet unsatisfied = Sets.newTreeSet();
        fields.retainAll(this.schemaDeps.keySet());
        for (String field : fields) {
            JsonNode subSchema = this.schemaDeps.get(field);
            JsonValidator validator = context.newValidator(subSchema);
            ValidationReport subReport = report.copy();
            validator.validate(context, subReport, instance);
            if (subReport.isSuccess()) continue;
            unsatisfied.add(field);
            report.mergeWith(subReport);
        }
        if (unsatisfied.isEmpty()) {
            return;
        }
        Message.Builder msg = this.newMsg().addInfo("unsatisfied", unsatisfied).setMessage("unsatisfied schema dependencies");
        report.addMessage(msg.build());
    }

    private void processPropertyDeps(ValidationReport report, JsonNode instance) {
        HashSet fields = Sets.newHashSet((Iterator)instance.fieldNames());
        for (String field : fields) {
            Set<String> deps = this.propertyDeps.get(field);
            if (deps == null) continue;
            HashSet missing = Sets.newHashSet(deps);
            missing.removeAll(fields);
            if (missing.isEmpty()) continue;
            report.addMessage(this.newMsg().addInfo("property", field).setMessage("unsatisfied property dependencies").addInfo("required", Ordering.natural().sortedCopy(deps)).addInfo("missing", Ordering.natural().sortedCopy((Iterable)missing)).build());
        }
    }

    @Override
    public String toString() {
        return "schema dependencies on properties: " + this.schemaDeps.keySet() + "; property dependencies on properties: " + this.propertyDeps.keySet();
    }
}

