/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import org.eel.kitchen.jsonschema.report.Domain;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public abstract class FormatAttribute {
    private final EnumSet<NodeType> typeSet;

    protected FormatAttribute(NodeType first, NodeType ... other) {
        this.typeSet = EnumSet.of(first, other);
    }

    public final void validate(String fmt, ValidationContext ctx, ValidationReport report, JsonNode value) {
        if (!this.typeSet.contains((Object)NodeType.getNodeType(value))) {
            return;
        }
        this.checkValue(fmt, ctx, report, value);
    }

    public abstract void checkValue(String var1, ValidationContext var2, ValidationReport var3, JsonNode var4);

    protected static Message.Builder newMsg(String fmt) {
        return Domain.VALIDATION.newMessage().setKeyword("format").addInfo("format", fmt);
    }
}

