/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractDateFormatAttribute
extends FormatAttribute {
    private final String errmsg;
    private final DateTimeFormatter dtf;

    protected AbstractDateFormatAttribute(String fmt, String desc) {
        super(NodeType.STRING, new NodeType[0]);
        this.dtf = DateTimeFormat.forPattern((String)fmt);
        this.errmsg = "string is not a valid " + desc;
    }

    @Override
    public final void checkValue(String fmt, ValidationContext ctx, ValidationReport report, JsonNode instance) {
        try {
            this.dtf.parseDateTime(instance.textValue());
        }
        catch (IllegalArgumentException ignored) {
            Message.Builder msg = AbstractDateFormatAttribute.newMsg(fmt).setMessage(this.errmsg).addInfo("value", instance);
            report.addMessage(msg.build());
        }
    }
}

