/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import org.eel.kitchen.jsonschema.report.ValidationDomain;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public abstract class FormatSpecifier {
    private final EnumSet<NodeType> typeSet;

    protected FormatSpecifier(NodeType first, NodeType ... other) {
        this.typeSet = EnumSet.of(first, other);
    }

    public final void validate(String fmt, ValidationContext ctx, ValidationReport report, JsonNode value) {
        if (!this.typeSet.contains((Object)NodeType.getNodeType(value))) {
            return;
        }
        this.checkValue(fmt, ctx, report, value);
    }

    public abstract void checkValue(String var1, ValidationContext var2, ValidationReport var3, JsonNode var4);

    protected static ValidationMessage.Builder newMsg(String fmt) {
        return new ValidationMessage.Builder(ValidationDomain.VALIDATION).setKeyword("format").addInfo("format", fmt);
    }
}

