/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.walk;

import com.github.fge.Thawed;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.messages.JsonSchemaSyntaxMessageBundle;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.syntax.dictionaries.DraftV4SyntaxCheckerDictionary;
import com.github.fge.jsonschema.walk.SchemaWalkingConfiguration;
import com.github.fge.jsonschema.walk.collectors.DraftV4PointerCollectorDictionary;
import com.github.fge.jsonschema.walk.collectors.PointerCollector;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.serviceloader.MessageBundleFactory;

public final class SchemaWalkingConfigurationBuilder
implements Thawed<SchemaWalkingConfiguration> {
    private static final MessageBundle BUNDLE = MessageBundleFactory.getBundle(JsonSchemaCoreMessageBundle.class);
    Dictionary<PointerCollector> collectors;
    Dictionary<SyntaxChecker> checkers;
    MessageBundle bundle;
    LoadingConfiguration loadingCfg;

    SchemaWalkingConfigurationBuilder() {
        this.collectors = DraftV4PointerCollectorDictionary.get();
        this.checkers = DraftV4SyntaxCheckerDictionary.get();
        this.loadingCfg = LoadingConfiguration.byDefault();
        this.bundle = MessageBundleFactory.getBundle(JsonSchemaSyntaxMessageBundle.class);
    }

    SchemaWalkingConfigurationBuilder(SchemaWalkingConfiguration cfg) {
        this.collectors = cfg.collectors;
        this.checkers = cfg.checkers;
        this.loadingCfg = cfg.loadingCfg;
    }

    public SchemaWalkingConfigurationBuilder setCheckers(Dictionary<SyntaxChecker> checkers) {
        this.checkers = checkers;
        return this;
    }

    public SchemaWalkingConfigurationBuilder setCollectors(Dictionary<PointerCollector> collectors) {
        this.collectors = collectors;
        return this;
    }

    public SchemaWalkingConfigurationBuilder setMessageBundle(MessageBundle bundle) {
        BUNDLE.checkNotNull((Object)bundle, "processing.nullBundle");
        this.bundle = bundle;
        return this;
    }

    public SchemaWalkingConfigurationBuilder setLoadingConfiguration(LoadingConfiguration loadingCfg) {
        BUNDLE.checkNotNull((Object)loadingCfg, "processing.nullLoadingCfg");
        this.loadingCfg = loadingCfg;
        return this;
    }

    public SchemaWalkingConfiguration freeze() {
        return new SchemaWalkingConfiguration(this);
    }
}

