/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.walk;

import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.walk.SchemaVisitor;
import com.github.fge.jsonschema.walk.collectors.PointerCollector;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;

public abstract class SchemaWalker2 {
    protected final Map<String, PointerCollector> pointerCollectors = Maps.newTreeMap();

    protected SchemaWalker2(Dictionary<PointerCollector> dict) {
        this.pointerCollectors.putAll(dict.entries());
    }

    public final <T> void accept(SchemaTree tree, SchemaVisitor<T> visitor) throws ProcessingException {
        this.doWalk(tree, visitor, JsonPointer.empty());
    }

    private <T> void doWalk(SchemaTree tree, SchemaVisitor<T> visitor, JsonPointer pointer) throws ProcessingException {
        visitor.enteringPath(pointer);
        SchemaTree newTree = this.resolveTree(tree);
        visitor.visitingPath(newTree);
        ArrayList pointers = Lists.newArrayList();
        for (Map.Entry<String, PointerCollector> entry : this.pointerCollectors.entrySet()) {
            if (!tree.getNode().has(entry.getKey())) continue;
            entry.getValue().collect(pointers, tree);
        }
        for (JsonPointer ptr : pointers) {
            this.doWalk(tree.append(ptr), visitor, pointer.append(ptr));
        }
        visitor.exitingPath(pointer);
    }

    protected abstract SchemaTree resolveTree(SchemaTree var1) throws ProcessingException;
}

