/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.walk;

import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.walk.SchemaListener;
import com.github.fge.jsonschema.walk.SchemaWalkingConfiguration;
import com.github.fge.jsonschema.walk.collectors.PointerCollector;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public abstract class SchemaWalker {
    protected SchemaTree tree;
    private final Map<String, PointerCollector> collectors;

    protected SchemaWalker(SchemaTree tree, SchemaWalkingConfiguration cfg) {
        this.tree = tree;
        this.collectors = cfg.collectors.entries();
    }

    public final <T> void walk(SchemaListener<T> listener, ProcessingReport report) throws ProcessingException {
        this.doWalk(JsonPointer.empty(), listener, report);
    }

    public abstract <T> void resolveTree(SchemaListener<T> var1, ProcessingReport var2) throws ProcessingException;

    private <T> void doWalk(JsonPointer pwd, SchemaListener<T> listener, ProcessingReport report) throws ProcessingException {
        listener.onEnter(pwd);
        this.resolveTree(listener, report);
        listener.onWalk(this.tree);
        TreeMap map = Maps.newTreeMap();
        map.putAll(this.collectors);
        map.keySet().retainAll(Sets.newHashSet((Iterator)this.tree.getNode().fieldNames()));
        ArrayList pointers = Lists.newArrayList();
        for (PointerCollector collector : map.values()) {
            collector.collect(pointers, this.tree);
        }
        for (JsonPointer pointer : pointers) {
            SchemaTree current = this.tree;
            this.tree = this.tree.append(pointer);
            this.doWalk(pointer, listener, report);
            this.tree = current;
        }
        listener.onExit(pwd);
    }

    public abstract String toString();
}

