/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.walk;

import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.exceptions.ExceptionProvider;
import com.github.fge.jsonschema.exceptions.InvalidSchemaException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.exceptions.SchemaWalkingException;
import com.github.fge.jsonschema.load.RefResolver;
import com.github.fge.jsonschema.load.SchemaLoader;
import com.github.fge.jsonschema.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorChain;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.SyntaxProcessor;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.ValueHolder;
import com.github.fge.jsonschema.util.equivalence.SchemaTreeEquivalence;
import com.github.fge.jsonschema.walk.SchemaListener;
import com.github.fge.jsonschema.walk.SchemaWalker;
import com.github.fge.jsonschema.walk.SchemaWalkingConfiguration;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.serviceloader.MessageBundleFactory;
import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;

public final class ResolvingSchemaWalker
extends SchemaWalker {
    private static final MessageBundle BUNDLE = MessageBundleFactory.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final Equivalence<SchemaTree> EQUIVALENCE = SchemaTreeEquivalence.getInstance();
    private static final ProcessingMessage MESSAGE = new ProcessingMessage().setMessage(BUNDLE.getMessage("core.invalidSchema")).setExceptionProvider(new ExceptionProvider(){

        @Override
        public ProcessingException doException(ProcessingMessage message) {
            return new InvalidSchemaException(message);
        }
    });
    private final Processor<ValueHolder<SchemaTree>, ValueHolder<SchemaTree>> processor;

    public ResolvingSchemaWalker(SchemaTree tree, SchemaWalkingConfiguration cfg) {
        super(tree, cfg);
        LoadingConfiguration loadingCfg = cfg.loadingCfg;
        SchemaLoader loader = new SchemaLoader(loadingCfg);
        RefResolver refResolver = new RefResolver(loader);
        SyntaxProcessor syntaxProcessor = new SyntaxProcessor(cfg.bundle, cfg.checkers);
        this.processor = ProcessorChain.startWith(refResolver).chainWith(syntaxProcessor).failOnError(MESSAGE).getProcessor();
    }

    public ResolvingSchemaWalker(SchemaTree tree) {
        this(tree, SchemaWalkingConfiguration.byDefault());
    }

    @Override
    public <T> void resolveTree(SchemaListener<T> listener, ProcessingReport report) throws ProcessingException {
        SchemaTree newTree = this.processor.process(report, ValueHolder.hold("schema", this.tree)).getValue();
        if (EQUIVALENCE.equivalent((Object)this.tree, (Object)newTree)) {
            return;
        }
        ResolvingSchemaWalker.checkTrees(this.tree, newTree);
        listener.onTreeChange(this.tree, newTree);
        this.tree = newTree;
    }

    @Override
    public String toString() {
        return "recursive tree walker ($ref resolution)";
    }

    private static void checkTrees(SchemaTree tree, SchemaTree newTree) throws ProcessingException {
        if (!tree.getLoadingRef().equals(newTree.getLoadingRef())) {
            return;
        }
        JsonPointer sourcePointer = tree.getPointer();
        JsonPointer targetPointer = newTree.getPointer();
        ArrayList sourceTokens = Lists.newArrayList((Iterable)sourcePointer);
        ArrayList targetTokens = Lists.newArrayList((Iterable)targetPointer);
        ProcessingMessage message = new ProcessingMessage().setMessage("").put("schemaURI", tree.getLoadingRef()).put("source", sourcePointer.toString()).put("target", targetPointer.toString());
        if (Collections.indexOfSubList(sourceTokens, targetTokens) == 0) {
            throw new SchemaWalkingException(message.setMessage(BUNDLE.getMessage("schemaWalking.parentExpand")));
        }
        if (Collections.indexOfSubList(targetTokens, sourceTokens) == 0) {
            throw new SchemaWalkingException(message.setMessage(BUNDLE.getMessage("schemaWalking.subtreeExpand")));
        }
    }
}

