/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.dictionaries;

import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.library.DictionaryBuilder;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.draftv3.DraftV3DependenciesSyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.draftv3.DraftV3ItemsSyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.draftv3.DraftV3PropertiesSyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.draftv3.ExtendsSyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.helpers.DivisorSyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.helpers.DraftV3TypeKeywordSyntaxChecker;
import com.github.fge.jsonschema.syntax.dictionaries.CommonSyntaxCheckerDictionary;

public final class DraftV3SyntaxCheckerDictionary {
    private static final Dictionary<SyntaxChecker> DICTIONARY;

    public static Dictionary<SyntaxChecker> get() {
        return DICTIONARY;
    }

    private DraftV3SyntaxCheckerDictionary() {
    }

    static {
        DictionaryBuilder<SyntaxChecker> builder = Dictionary.newBuilder();
        builder.addAll(CommonSyntaxCheckerDictionary.get());
        String keyword = "items";
        SyntaxChecker checker = DraftV3ItemsSyntaxChecker.getInstance();
        builder.addEntry(keyword, checker);
        keyword = "divisibleBy";
        checker = new DivisorSyntaxChecker(keyword);
        builder.addEntry(keyword, checker);
        keyword = "properties";
        checker = DraftV3PropertiesSyntaxChecker.getInstance();
        builder.addEntry(keyword, checker);
        keyword = "dependencies";
        checker = DraftV3DependenciesSyntaxChecker.getInstance();
        builder.addEntry(keyword, checker);
        keyword = "extends";
        checker = ExtendsSyntaxChecker.getInstance();
        builder.addEntry(keyword, checker);
        keyword = "type";
        checker = new DraftV3TypeKeywordSyntaxChecker(keyword);
        builder.addEntry(keyword, checker);
        keyword = "disallow";
        checker = new DraftV3TypeKeywordSyntaxChecker(keyword);
        builder.addEntry(keyword, checker);
        DICTIONARY = builder.freeze();
    }
}

