/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.checkers.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.Collection;

public abstract class SchemaOrSchemaArraySyntaxChecker
extends AbstractSyntaxChecker {
    protected SchemaOrSchemaArraySyntaxChecker(String keyword) {
        super(keyword, NodeType.ARRAY, NodeType.OBJECT);
    }

    @Override
    protected final void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        this.collectPointers(pointers, tree);
        this.extraChecks(report, bundle, tree);
    }

    protected abstract void extraChecks(ProcessingReport var1, MessageBundle var2, SchemaTree var3) throws ProcessingException;

    private void collectPointers(Collection<JsonPointer> pointers, SchemaTree tree) {
        JsonNode node = this.getNode(tree);
        if (node.isObject()) {
            pointers.add(JsonPointer.of((Object)this.keyword, (Object[])new Object[0]));
            return;
        }
        for (int index = 0; index < node.size(); ++index) {
            pointers.add(JsonPointer.of((Object)this.keyword, (Object[])new Object[]{index}));
        }
    }
}

