/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.preprocessing;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.walk.SchemaListener;

public final class Preprocessing {

    private static enum PreprocessorType {
        NOREF,
        INTERNALREFS,
        FULL;

    }

    private static final class SchemaPreprocessor
    implements SchemaListener<PreprocessorType> {
        private final SchemaTree schema;
        private final JsonRef location;
        PreprocessorType type = PreprocessorType.NOREF;

        private SchemaPreprocessor(SchemaTree schema) {
            this.schema = schema;
            this.location = schema.getLoadingRef();
        }

        @Override
        public void onTreeChange(SchemaTree oldTree, SchemaTree newTree) throws ProcessingException {
        }

        @Override
        public void onWalk(SchemaTree tree) throws ProcessingException {
            JsonRef ref;
            JsonNode node = tree.getNode();
            JsonNode refNode = node.path("$ref");
            if (!refNode.isTextual()) {
                return;
            }
            try {
                ref = JsonRef.fromString(refNode.textValue());
                if (this.type.compareTo(PreprocessorType.INTERNALREFS) < 0) {
                    this.type = PreprocessorType.INTERNALREFS;
                }
            }
            catch (JsonReferenceException ignored) {
                return;
            }
            JsonRef resolvedRef = tree.resolve(ref);
            if (tree.containsRef(resolvedRef)) {
                return;
            }
            if (this.type.compareTo(PreprocessorType.FULL) < 0) {
                this.type = PreprocessorType.FULL;
            }
        }

        @Override
        public void onEnter(JsonPointer pointer) throws ProcessingException {
        }

        @Override
        public void onExit(JsonPointer pointer) throws ProcessingException {
        }

        @Override
        public PreprocessorType getValue() {
            return null;
        }
    }
}

