/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.Thawed;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.library.DictionaryBuilder;
import com.github.fge.jsonschema.load.DefaultDownloadersDictionary;
import com.github.fge.jsonschema.load.Dereferencing;
import com.github.fge.jsonschema.load.URIDownloader;
import com.github.fge.jsonschema.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.serviceloader.MessageBundleFactory;
import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public final class LoadingConfigurationBuilder
implements Thawed<LoadingConfiguration> {
    private static final MessageBundle BUNDLE = MessageBundleFactory.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final URI EMPTY_NAMESPACE = URI.create("#");
    final DictionaryBuilder<URIDownloader> downloaders;
    URI namespace;
    Dereferencing dereferencing;
    final Map<URI, URI> schemaRedirects;
    final Map<URI, JsonNode> preloadedSchemas;

    LoadingConfigurationBuilder() {
        this.downloaders = DefaultDownloadersDictionary.get().thaw();
        this.namespace = EMPTY_NAMESPACE;
        this.dereferencing = Dereferencing.CANONICAL;
        this.schemaRedirects = Maps.newHashMap();
        this.preloadedSchemas = Maps.newHashMap();
        for (SchemaVersion version : SchemaVersion.values()) {
            this.preloadedSchemas.put(version.getLocation(), version.getSchema());
        }
    }

    LoadingConfigurationBuilder(LoadingConfiguration cfg) {
        this.downloaders = cfg.downloaders.thaw();
        this.namespace = cfg.namespace;
        this.dereferencing = cfg.dereferencing;
        this.schemaRedirects = Maps.newHashMap(cfg.schemaRedirects);
        this.preloadedSchemas = Maps.newHashMap(cfg.preloadedSchemas);
    }

    public LoadingConfigurationBuilder addScheme(String scheme, URIDownloader downloader) {
        this.downloaders.addEntry(LoadingConfigurationBuilder.checkScheme(scheme), downloader);
        return this;
    }

    public LoadingConfigurationBuilder removeScheme(String scheme) {
        this.downloaders.removeEntry(scheme);
        return this;
    }

    public LoadingConfigurationBuilder setNamespace(String input) {
        this.namespace = LoadingConfigurationBuilder.getLocator(input);
        return this;
    }

    public LoadingConfigurationBuilder dereferencing(Dereferencing dereferencing) {
        BUNDLE.checkNotNull((Object)dereferencing, "loadingCfg.nullDereferencingMode");
        this.dereferencing = dereferencing;
        return this;
    }

    public LoadingConfigurationBuilder addSchemaRedirect(String source, String destination) {
        URI sourceURI = LoadingConfigurationBuilder.getLocator(source);
        URI destinationURI = LoadingConfigurationBuilder.getLocator(destination);
        this.schemaRedirects.put(sourceURI, destinationURI);
        BUNDLE.checkArgumentPrintf(!sourceURI.equals(destinationURI), "loadingCfg.redirectToSelf", new Object[]{sourceURI});
        return this;
    }

    public LoadingConfigurationBuilder preloadSchema(String uri, JsonNode schema) {
        BUNDLE.checkNotNull((Object)schema, "loadingCfg.nullSchema");
        URI key = LoadingConfigurationBuilder.getLocator(uri);
        BUNDLE.checkArgumentPrintf(this.preloadedSchemas.put(key, schema) == null, "loadingCfg.duplicateURI", new Object[]{key});
        return this;
    }

    public LoadingConfigurationBuilder preloadSchema(JsonNode schema) {
        JsonNode node = schema.path("id");
        BUNDLE.checkArgument(node.isTextual(), "loadingCfg.noIDInSchema");
        return this.preloadSchema(node.textValue(), schema);
    }

    public LoadingConfiguration freeze() {
        return new LoadingConfiguration(this);
    }

    private static String checkScheme(String scheme) {
        BUNDLE.checkNotNull((Object)scheme, "loadingCfg.nullScheme");
        BUNDLE.checkArgument(!scheme.isEmpty(), "loadingCfg.emptyScheme");
        try {
            new URI(scheme, "x", "y");
        }
        catch (URISyntaxException ignored) {
            throw new IllegalArgumentException(BUNDLE.printf("loadingCfg.illegalScheme", new Object[]{scheme}));
        }
        return scheme;
    }

    private static URI getLocator(String input) {
        JsonRef ref;
        try {
            ref = JsonRef.fromString(input);
        }
        catch (JsonReferenceException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        BUNDLE.checkArgumentPrintf(ref.isAbsolute(), "jsonRef.notAbsolute", new Object[]{ref});
        return ref.getLocator();
    }
}

