/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.Frozen;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.load.Dereferencing;
import com.github.fge.jsonschema.load.URIDownloader;
import com.github.fge.jsonschema.load.configuration.LoadingConfigurationBuilder;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;

public final class LoadingConfiguration
implements Frozen<LoadingConfigurationBuilder> {
    final Dictionary<URIDownloader> downloaders;
    final URI namespace;
    final Dereferencing dereferencing;
    final Map<URI, URI> schemaRedirects;
    final Map<URI, JsonNode> preloadedSchemas;

    public static LoadingConfigurationBuilder newBuilder() {
        return new LoadingConfigurationBuilder();
    }

    public static LoadingConfiguration byDefault() {
        return new LoadingConfigurationBuilder().freeze();
    }

    LoadingConfiguration(LoadingConfigurationBuilder cfg) {
        this.downloaders = cfg.downloaders.freeze();
        this.namespace = cfg.namespace;
        this.dereferencing = cfg.dereferencing;
        this.schemaRedirects = ImmutableMap.copyOf(cfg.schemaRedirects);
        this.preloadedSchemas = ImmutableMap.copyOf(cfg.preloadedSchemas);
    }

    public Dictionary<URIDownloader> getDownloaders() {
        return this.downloaders;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public Dereferencing getDereferencing() {
        return this.dereferencing;
    }

    public Map<URI, URI> getSchemaRedirects() {
        return this.schemaRedirects;
    }

    public Map<URI, JsonNode> getPreloadedSchemas() {
        return this.preloadedSchemas;
    }

    public LoadingConfigurationBuilder thaw() {
        return new LoadingConfigurationBuilder(this);
    }
}

