/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.load.URIDownloader;
import com.github.fge.jsonschema.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.serviceloader.MessageBundleFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;

public final class URIManager {
    private static final MessageBundle BUNDLE = MessageBundleFactory.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final ObjectReader READER = JacksonUtils.getReader();
    private final Map<String, URIDownloader> downloaders;
    private final Map<URI, URI> schemaRedirects;

    public URIManager() {
        this(LoadingConfiguration.byDefault());
    }

    public URIManager(LoadingConfiguration cfg) {
        this.downloaders = cfg.getDownloaders().entries();
        this.schemaRedirects = cfg.getSchemaRedirects();
    }

    public JsonNode getContent(URI uri) throws ProcessingException {
        URI target;
        Preconditions.checkNotNull((Object)uri, (Object)"null URI");
        URI uRI = target = this.schemaRedirects.containsKey(uri) ? this.schemaRedirects.get(uri) : uri;
        if (!target.isAbsolute()) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.uriNotAbsolute")).put("uri", uri));
        }
        String scheme = target.getScheme();
        URIDownloader downloader = this.downloaders.get(scheme);
        if (downloader == null) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.unhandledScheme")).putArgument("scheme", scheme).putArgument("uri", uri));
        }
        try {
            InputStream in = downloader.fetch(target);
            return READER.readTree(in);
        }
        catch (JsonProcessingException e) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.uriNotJson")).putArgument("uri", uri).put("parsingMessage", e.getOriginalMessage()));
        }
        catch (IOException e) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.uriIOError")).putArgument("uri", uri).put("exceptionMessage", e.getMessage()));
        }
    }
}

