/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.load;

import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.library.DictionaryBuilder;
import com.github.fge.jsonschema.load.DefaultURIDownloader;
import com.github.fge.jsonschema.load.ResourceURIDownloader;
import com.github.fge.jsonschema.load.URIDownloader;

public final class DefaultDownloadersDictionary {
    private static final Dictionary<URIDownloader> DICTIONARY;

    private DefaultDownloadersDictionary() {
    }

    public static Dictionary<URIDownloader> get() {
        return DICTIONARY;
    }

    static {
        DictionaryBuilder<URIDownloader> builder = Dictionary.newBuilder();
        String scheme = "http";
        URIDownloader downloader = DefaultURIDownloader.getInstance();
        builder.addEntry(scheme, downloader);
        scheme = "https";
        downloader = DefaultURIDownloader.getInstance();
        builder.addEntry(scheme, downloader);
        scheme = "file";
        downloader = DefaultURIDownloader.getInstance();
        builder.addEntry(scheme, downloader);
        scheme = "ftp";
        downloader = DefaultURIDownloader.getInstance();
        builder.addEntry(scheme, downloader);
        scheme = "jar";
        downloader = DefaultURIDownloader.getInstance();
        builder.addEntry(scheme, downloader);
        scheme = "resource";
        downloader = ResourceURIDownloader.getInstance();
        builder.addEntry(scheme, downloader);
        DICTIONARY = builder.freeze();
    }
}

