/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.expand;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.tree.CanonicalSchemaTree;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.walk.SchemaListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Deque;

public final class SchemaExpander
implements SchemaListener<SchemaTree> {
    private final JsonRef baseRef;
    private JsonNode baseNode;
    private JsonPointer path = JsonPointer.empty();
    private final Deque<JsonPointer> paths = Queues.newArrayDeque();

    public SchemaExpander(SchemaTree tree) {
        this.baseRef = tree.getLoadingRef();
        this.baseNode = tree.getBaseNode().deepCopy();
    }

    @Override
    public void onTreeChange(SchemaTree oldTree, SchemaTree newTree) throws ProcessingException {
        JsonNode newNode = newTree.getNode().deepCopy();
        if (this.path.isEmpty()) {
            this.baseNode = newNode;
            return;
        }
        JsonPointer parent = this.path.parent();
        String token = SchemaExpander.getLastToken(this.path);
        JsonNode parentNode = (JsonNode)parent.get((TreeNode)this.baseNode);
        NodeType type = NodeType.getNodeType((JsonNode)parentNode);
        switch (type) {
            case OBJECT: {
                ((ObjectNode)parentNode).put(token, newNode);
                break;
            }
            case ARRAY: {
                ((ArrayNode)parentNode).set(Integer.parseInt(token), newNode);
                break;
            }
            default: {
                throw new IllegalStateException("was expecting an object or an array");
            }
        }
    }

    @Override
    public void onWalk(SchemaTree tree) throws ProcessingException {
    }

    @Override
    public void onEnter(JsonPointer pointer) throws ProcessingException {
        JsonPointer ptr = this.path.append(pointer);
        this.paths.push(this.path);
        this.path = ptr;
    }

    @Override
    public void onExit(JsonPointer pointer) throws ProcessingException {
        this.path = this.paths.pop();
    }

    @Override
    public SchemaTree getValue() {
        return new CanonicalSchemaTree(this.baseRef, this.baseNode);
    }

    private static String getLastToken(JsonPointer ptr) {
        ArrayList list = Lists.newArrayList((Iterable)ptr);
        int size = list.size();
        return ((TokenResolver)list.get(size - 1)).getToken().getRaw();
    }
}

