/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.checkers.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import com.github.fge.jsonschema.util.equivalence.JsonSchemaEquivalence;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;

public final class RequiredSyntaxChecker
extends AbstractSyntaxChecker {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonSchemaEquivalence.getInstance();
    private static final SyntaxChecker INSTANCE = new RequiredSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private RequiredSyntaxChecker() {
        super("required", NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        int size = node.size();
        if (size == 0) {
            report.error(this.newMsg(tree, SyntaxMessages.EMPTY_ARRAY));
            return;
        }
        HashSet set = Sets.newHashSet();
        boolean uniqueElements = true;
        for (int index = 0; index < size; ++index) {
            JsonNode element = node.get(index);
            uniqueElements = set.add(EQUIVALENCE.wrap((Object)element));
            NodeType type = NodeType.getNodeType(element);
            if (type == NodeType.STRING) continue;
            report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_ELEMENT_TYPE).put("index", index).put("expected", EnumSet.of(NodeType.STRING)).put("found", type));
        }
        if (!uniqueElements) {
            report.error(this.newMsg(tree, SyntaxMessages.ELEMENTS_NOT_UNIQUE));
        }
    }
}

