/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.checkers.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.helpers.DependenciesSyntaxChecker;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;

public final class DraftV3DependenciesSyntaxChecker
extends DependenciesSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new DraftV3DependenciesSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private DraftV3DependenciesSyntaxChecker() {
        super(NodeType.ARRAY, NodeType.STRING);
    }

    @Override
    protected void checkDependency(ProcessingReport report, String name, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree).get(name);
        NodeType type = NodeType.getNodeType(node);
        if (type == NodeType.STRING) {
            return;
        }
        if (type != NodeType.ARRAY) {
            report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_DEPENDENCY_VALUE).put("property", name).put("expected", this.dependencyTypes).put("found", type));
            return;
        }
        int size = node.size();
        if (size == 0) {
            report.warn(this.newMsg(tree, SyntaxMessages.EMPTY_ARRAY).put("property", name));
            return;
        }
        HashSet set = Sets.newHashSet();
        boolean uniqueElements = true;
        for (int index = 0; index < size; ++index) {
            JsonNode element = node.get(index);
            type = NodeType.getNodeType(element);
            uniqueElements = set.add(EQUIVALENCE.wrap((Object)element));
            if (type == NodeType.STRING) continue;
            report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_ELEMENT_TYPE).put("property", name).put("index", index).put("expected", EnumSet.of(NodeType.STRING)).put("found", type));
        }
        if (!uniqueElements) {
            report.warn(this.newMsg(tree, SyntaxMessages.ELEMENTS_NOT_UNIQUE).put("property", name));
        }
    }
}

