/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.jsonpointer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.github.fge.jsonschema.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.exceptions.unchecked.JsonReferenceError;
import com.github.fge.jsonschema.jsonpointer.JsonNodeResolver;
import com.github.fge.jsonschema.jsonpointer.ReferenceToken;
import com.github.fge.jsonschema.jsonpointer.TokenResolver;
import com.github.fge.jsonschema.jsonpointer.TreePointer;
import com.github.fge.jsonschema.messages.JsonReferenceErrors;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class JsonPointer
extends TreePointer<JsonNode> {
    private static final JsonPointer EMPTY = new JsonPointer((List<TokenResolver<JsonNode>>)ImmutableList.of());

    public static JsonPointer empty() {
        return EMPTY;
    }

    public static JsonPointer of(Object first, Object ... other) {
        ArrayList tokens = Lists.newArrayList();
        tokens.add(ReferenceToken.fromRaw(first.toString()));
        for (Object o : other) {
            tokens.add(ReferenceToken.fromRaw(o.toString()));
        }
        return new JsonPointer(JsonPointer.fromTokens(tokens));
    }

    public JsonPointer(String input) throws JsonReferenceException {
        this(JsonPointer.fromTokens(JsonPointer.tokensFromInput(input)));
    }

    public JsonPointer(List<TokenResolver<JsonNode>> tokenResolvers) {
        super(MissingNode.getInstance(), tokenResolvers);
    }

    public JsonPointer append(String raw) {
        ReferenceToken refToken = ReferenceToken.fromRaw(raw);
        JsonNodeResolver resolver = new JsonNodeResolver(refToken);
        ArrayList list = Lists.newArrayList((Iterable)this.tokenResolvers);
        list.add(resolver);
        return new JsonPointer(list);
    }

    public JsonPointer append(int index) {
        return this.append(Integer.toString(index));
    }

    public JsonPointer append(JsonPointer other) {
        if (other == null) {
            throw new JsonReferenceError(new ProcessingMessage().message(JsonReferenceErrors.NULL_JSON_POINTER));
        }
        ArrayList list = Lists.newArrayList((Iterable)this.tokenResolvers);
        list.addAll(other.tokenResolvers);
        return new JsonPointer(list);
    }

    private static List<TokenResolver<JsonNode>> fromTokens(List<ReferenceToken> tokens) {
        ArrayList list = Lists.newArrayList();
        for (ReferenceToken token : tokens) {
            list.add(new JsonNodeResolver(token));
        }
        return list;
    }
}

