/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.exceptions.JsonPatchException;
import com.github.fge.jsonschema.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.messages.JsonPatchMessages;

public final class RemoveOperation
extends JsonPatchOperation {
    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public RemoveOperation(@JsonProperty(value="path") JsonPointer path) {
        super(path);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.path.isEmpty()) {
            return MissingNode.getInstance();
        }
        if (this.path.path(node).isMissingNode()) {
            throw new JsonPatchException(JsonPatchMessages.NO_SUCH_PATH.newMessage().put("node", node).put("path", this.path.toString()));
        }
        JsonPatchOperation.SplitPointer split = new JsonPatchOperation.SplitPointer(this.path);
        JsonNode ret = node.deepCopy();
        JsonNode parentNode = split.parent.get(ret);
        String raw = split.lastToken.getToken().getRaw();
        if (parentNode.isObject()) {
            ((ObjectNode)parentNode).remove(raw);
        } else {
            ((ArrayNode)parentNode).remove(Integer.parseInt(raw));
        }
        return ret;
    }

    @Override
    public String toString() {
        return "remove: " + super.toString();
    }
}

