/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.JsonPatchException;
import com.github.fge.jsonschema.jsonpatch.AddOperation;
import com.github.fge.jsonschema.jsonpatch.DualPathOperation;
import com.github.fge.jsonschema.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonschema.jsonpatch.RemoveOperation;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.messages.JsonPatchMessages;

public final class MoveOperation
extends DualPathOperation {
    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MoveOperation(@JsonProperty(value="from") JsonPointer from, @JsonProperty(value="path") JsonPointer path) {
        super(from, path);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.from.equals(this.path)) {
            return node.deepCopy();
        }
        JsonNode movedNode = this.from.path(node);
        if (movedNode.isMissingNode()) {
            throw new JsonPatchException(JsonPatchMessages.NO_SUCH_PATH.newMessage().put("node", node).put("path", this.from.toString()));
        }
        RemoveOperation remove = new RemoveOperation(this.from);
        AddOperation add = new AddOperation(this.path, movedNode);
        return ((JsonPatchOperation)add).apply(((JsonPatchOperation)remove).apply(node));
    }

    @Override
    public String toString() {
        return "move: " + super.toString();
    }
}

