/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.jsonpatch;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.JsonPatchException;
import com.github.fge.jsonschema.jsonpatch.AddOperation;
import com.github.fge.jsonschema.jsonpatch.CopyOperation;
import com.github.fge.jsonschema.jsonpatch.MoveOperation;
import com.github.fge.jsonschema.jsonpatch.RemoveOperation;
import com.github.fge.jsonschema.jsonpatch.ReplaceOperation;
import com.github.fge.jsonschema.jsonpatch.TestOperation;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.jsonpointer.TokenResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="op")
@JsonSubTypes(value={@JsonSubTypes.Type(name="add", value=AddOperation.class), @JsonSubTypes.Type(name="copy", value=CopyOperation.class), @JsonSubTypes.Type(name="move", value=MoveOperation.class), @JsonSubTypes.Type(name="remove", value=RemoveOperation.class), @JsonSubTypes.Type(name="replace", value=ReplaceOperation.class), @JsonSubTypes.Type(name="test", value=TestOperation.class)})
public abstract class JsonPatchOperation {
    protected final JsonPointer path;

    protected JsonPatchOperation(JsonPointer path) {
        this.path = path;
    }

    public abstract JsonNode apply(JsonNode var1) throws JsonPatchException;

    public String toString() {
        return "path = \"" + this.path + '\"';
    }

    protected static final class SplitPointer {
        final JsonPointer parent;
        final TokenResolver<JsonNode> lastToken;

        SplitPointer(JsonPointer pointer) {
            ArrayList tokens = Lists.newArrayList((Iterable)pointer);
            this.lastToken = (TokenResolver)tokens.remove(tokens.size() - 1);
            this.parent = new JsonPointer(tokens);
        }
    }
}

