/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.exceptions.JsonPatchException;
import com.github.fge.jsonschema.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonschema.jsonpatch.PathValueOperation;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.jsonpointer.ReferenceToken;
import com.github.fge.jsonschema.jsonpointer.TokenResolver;
import com.github.fge.jsonschema.messages.JsonPatchMessages;

public final class AddOperation
extends PathValueOperation {
    private static final ReferenceToken LAST_ARRAY_ELEMENT = ReferenceToken.fromRaw("-");

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public AddOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="value") JsonNode value) {
        super(path, value);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.path.isEmpty()) {
            return this.value;
        }
        JsonPatchOperation.SplitPointer split = new JsonPatchOperation.SplitPointer(this.path);
        JsonNode parentNode = split.parent.path(node);
        if (parentNode.isMissingNode()) {
            throw new JsonPatchException(JsonPatchMessages.NO_SUCH_PARENT.newMessage().put("node", node).put("path", this.path.toString()));
        }
        return parentNode.isArray() ? this.addToArray(split, node) : this.addToObject(split, node);
    }

    private JsonNode addToArray(JsonPatchOperation.SplitPointer split, JsonNode node) throws JsonPatchException {
        int index;
        JsonNode ret = node.deepCopy();
        ArrayNode target = (ArrayNode)split.parent.get(ret);
        TokenResolver<JsonNode> token = split.lastToken;
        if (token.getToken().equals(LAST_ARRAY_ELEMENT)) {
            target.add(this.value);
            return ret;
        }
        int size = target.size();
        try {
            index = Integer.parseInt(token.toString());
        }
        catch (NumberFormatException ignored) {
            throw new JsonPatchException(JsonPatchMessages.NOT_AN_INDEX.newMessage().put("token", token.getToken().getRaw()));
        }
        if (index < 0 || index >= size) {
            throw new JsonPatchException(JsonPatchMessages.NO_SUCH_INDEX.newMessage().put("reminder", "array indices start at 0").put("arraySize", size).put("index", index));
        }
        target.insert(index, this.value);
        return ret;
    }

    private JsonNode addToObject(JsonPatchOperation.SplitPointer split, JsonNode node) {
        JsonNode ret = node.deepCopy();
        ObjectNode target = (ObjectNode)split.parent.get(ret);
        target.put(split.lastToken.getToken().getRaw(), this.value);
        return ret;
    }

    @Override
    public String toString() {
        return "add: " + super.toString();
    }
}

