/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.walk;

import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.walk.SchemaListener;
import com.github.fge.jsonschema.walk.collectors.DraftV3PointerCollectorDictionary;
import com.github.fge.jsonschema.walk.collectors.DraftV4PointerCollectorDictionary;
import com.github.fge.jsonschema.walk.collectors.PointerCollector;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public abstract class SchemaWalker {
    protected SchemaTree tree;
    private final Map<String, PointerCollector> collectors;

    protected SchemaWalker(SchemaTree tree, SchemaVersion version) {
        this.collectors = version == SchemaVersion.DRAFTV4 ? DraftV4PointerCollectorDictionary.get().entries() : DraftV3PointerCollectorDictionary.get().entries();
        this.tree = tree;
    }

    protected SchemaWalker(SchemaTree tree, Dictionary<PointerCollector> dict) {
        this.collectors = dict.entries();
        this.tree = tree;
    }

    public final <T> void walk(SchemaListener<T> listener, ProcessingReport report) throws ProcessingException {
        listener.onInit(this.tree);
        this.doWalk(listener, report);
        listener.onExit();
    }

    public abstract <T> void resolveTree(SchemaListener<T> var1, ProcessingReport var2) throws ProcessingException;

    private <T> void doWalk(SchemaListener<T> listener, ProcessingReport report) throws ProcessingException {
        listener.onWalk(this.tree);
        this.resolveTree(listener, report);
        TreeMap map = Maps.newTreeMap();
        map.putAll(this.collectors);
        map.keySet().retainAll(Sets.newHashSet((Iterator)this.tree.getNode().fieldNames()));
        ArrayList pointers = Lists.newArrayList();
        for (PointerCollector collector : map.values()) {
            collector.collect(pointers, this.tree);
        }
        for (JsonPointer pointer : pointers) {
            SchemaTree current = this.tree;
            this.tree = this.tree.append(pointer);
            listener.onPushd(pointer);
            this.doWalk(listener, report);
            listener.onPopd();
            this.tree = current;
        }
    }

    public abstract String toString();
}

