/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.cfg;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.cfg.LoadingConfiguration;
import com.github.fge.jsonschema.cfg.RefSanityChecks;
import com.github.fge.jsonschema.exceptions.unchecked.LoadingConfigurationError;
import com.github.fge.jsonschema.library.DictionaryBuilder;
import com.github.fge.jsonschema.load.DefaultDownloadersDictionary;
import com.github.fge.jsonschema.load.Dereferencing;
import com.github.fge.jsonschema.load.URIDownloader;
import com.github.fge.jsonschema.messages.LoadingConfigurationMessages;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.util.Thawed;
import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public final class LoadingConfigurationBuilder
implements Thawed<LoadingConfiguration> {
    private static final URI EMPTY_NAMESPACE = URI.create("#");
    final DictionaryBuilder<URIDownloader> downloaders;
    URI namespace;
    boolean enableCache = true;
    Dereferencing dereferencing;
    final Map<URI, URI> schemaRedirects;
    final Map<URI, JsonNode> preloadedSchemas;

    LoadingConfigurationBuilder() {
        this.downloaders = DefaultDownloadersDictionary.get().thaw();
        this.namespace = EMPTY_NAMESPACE;
        this.dereferencing = Dereferencing.CANONICAL;
        this.schemaRedirects = Maps.newHashMap();
        this.preloadedSchemas = Maps.newHashMap();
        for (SchemaVersion version : SchemaVersion.values()) {
            this.preloadedSchemas.put(version.getLocation(), version.getSchema());
        }
    }

    LoadingConfigurationBuilder(LoadingConfiguration cfg) {
        this.downloaders = cfg.downloaders.thaw();
        this.namespace = cfg.namespace;
        this.dereferencing = cfg.dereferencing;
        this.schemaRedirects = Maps.newHashMap(cfg.schemaRedirects);
        this.preloadedSchemas = Maps.newHashMap(cfg.preloadedSchemas);
        this.enableCache = cfg.enableCache;
    }

    public LoadingConfigurationBuilder setEnableCache(boolean enableCache) {
        this.enableCache = enableCache;
        return this;
    }

    public LoadingConfigurationBuilder addScheme(String scheme, URIDownloader downloader) {
        this.downloaders.addEntry(LoadingConfigurationBuilder.checkScheme(scheme), downloader);
        return this;
    }

    public LoadingConfigurationBuilder removeScheme(String scheme) {
        this.downloaders.removeEntry(scheme);
        return this;
    }

    public LoadingConfigurationBuilder setNamespace(String input) {
        this.namespace = RefSanityChecks.absoluteLocator(input);
        return this;
    }

    public LoadingConfigurationBuilder dereferencing(Dereferencing dereferencing) {
        if (dereferencing == null) {
            throw new LoadingConfigurationError(new ProcessingMessage().message(LoadingConfigurationMessages.NULL_DEREFERENCING_MODE));
        }
        this.dereferencing = dereferencing;
        return this;
    }

    public LoadingConfigurationBuilder addSchemaRedirect(String source, String destination) {
        URI sourceURI = RefSanityChecks.absoluteLocator(source);
        URI destinationURI = RefSanityChecks.absoluteLocator(destination);
        this.schemaRedirects.put(sourceURI, destinationURI);
        if (sourceURI.equals(destinationURI)) {
            throw new LoadingConfigurationError(new ProcessingMessage().message(LoadingConfigurationMessages.REDIRECT_TO_SELF).put("uri", sourceURI));
        }
        return this;
    }

    public LoadingConfigurationBuilder preloadSchema(String uri, JsonNode schema) {
        ProcessingMessage message = new ProcessingMessage();
        if (schema == null) {
            throw new LoadingConfigurationError(message.message(LoadingConfigurationMessages.NULL_SCHEMA));
        }
        URI key = RefSanityChecks.absoluteLocator(uri);
        if (this.preloadedSchemas.containsKey(key)) {
            throw new LoadingConfigurationError(message.message(LoadingConfigurationMessages.DUPLICATE_URI).put("uri", key));
        }
        this.preloadedSchemas.put(key, schema);
        return this;
    }

    public LoadingConfigurationBuilder preloadSchema(JsonNode schema) {
        JsonNode node = schema.path("id");
        if (!node.isTextual()) {
            throw new LoadingConfigurationError(new ProcessingMessage().message(LoadingConfigurationMessages.NO_ID_IN_SCHEMA));
        }
        return this.preloadSchema(node.textValue(), schema);
    }

    @Override
    public LoadingConfiguration freeze() {
        return new LoadingConfiguration(this);
    }

    private static String checkScheme(String scheme) {
        ProcessingMessage message = new ProcessingMessage();
        if (scheme == null) {
            throw new LoadingConfigurationError(message.message(LoadingConfigurationMessages.NULL_SCHEME));
        }
        if (scheme.isEmpty()) {
            throw new LoadingConfigurationError(message.message(LoadingConfigurationMessages.EMPTY_SCHEME));
        }
        try {
            new URI(scheme, "x", "y");
        }
        catch (URISyntaxException ignored) {
            throw new LoadingConfigurationError(message.message(LoadingConfigurationMessages.ILLEGAL_SCHEME).put("scheme", scheme));
        }
        return scheme;
    }
}

