/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class JacksonUtils {
    private static final JsonNodeFactory FACTORY = JsonNodeFactory.withExactBigDecimals((boolean)false);
    private static final ObjectReader READER;
    private static final ObjectWriter WRITER;

    private JacksonUtils() {
    }

    public static ObjectReader getReader() {
        return READER;
    }

    public static JsonNodeFactory nodeFactory() {
        return FACTORY;
    }

    public static Map<String, JsonNode> asMap(JsonNode node) {
        if (!node.isObject()) {
            return Collections.emptyMap();
        }
        Iterator iterator = node.fields();
        HashMap ret = Maps.newHashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prettyPrint(JsonNode node) {
        StringWriter writer = new StringWriter();
        try {
            WRITER.writeValue((Writer)writer, (Object)node);
            writer.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            Closeables.closeQuietly((Closeable)writer);
        }
        return writer.toString();
    }

    static {
        ObjectMapper mapper = new ObjectMapper().setNodeFactory(FACTORY).enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        READER = mapper.reader();
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }
}

