/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library;

import com.github.fge.jsonschema.exceptions.unchecked.DictionaryBuildError;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.messages.DictionaryBuildErrors;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.util.Thawed;
import com.google.common.collect.Maps;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class DictionaryBuilder<T>
implements Thawed<Dictionary<T>> {
    final Map<String, T> entries = Maps.newHashMap();

    DictionaryBuilder() {
    }

    DictionaryBuilder(Dictionary<T> dict) {
        this.entries.putAll(dict.entries);
    }

    public DictionaryBuilder<T> addEntry(String key, T value) {
        if (key == null) {
            throw new DictionaryBuildError(new ProcessingMessage().message(DictionaryBuildErrors.NULL_KEY));
        }
        if (value == null) {
            throw new DictionaryBuildError(new ProcessingMessage().message(DictionaryBuildErrors.NULL_VALUE));
        }
        this.entries.put(key, value);
        return this;
    }

    public DictionaryBuilder<T> addAll(Dictionary<T> other) {
        if (other == null) {
            throw new DictionaryBuildError(new ProcessingMessage().message(DictionaryBuildErrors.NULL_DICT));
        }
        this.entries.putAll(other.entries);
        return this;
    }

    public DictionaryBuilder<T> removeEntry(String key) {
        this.entries.remove(key);
        return this;
    }

    @Override
    public Dictionary<T> freeze() {
        return new Dictionary(this);
    }
}

