/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class JsonDiff {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();

    private JsonDiff() {
    }

    public static JsonNode asJson(JsonNode first, JsonNode second) {
        ArrayNode ret = FACTORY.arrayNode();
        ArrayList ops = Lists.newArrayList();
        JsonDiff.genDiff(ops, JsonPointer.empty(), first, second);
        ret.addAll((Collection)ops);
        return ret;
    }

    private static void genDiff(List<JsonNode> ops, JsonPointer ptr, JsonNode first, JsonNode second) {
        NodeType secondType;
        if (JsonNumEquals.getInstance().equivalent((Object)first, (Object)second)) {
            return;
        }
        NodeType firstType = NodeType.getNodeType((JsonNode)first);
        if (firstType != (secondType = NodeType.getNodeType((JsonNode)second)) || !first.isContainerNode()) {
            ObjectNode op = JsonDiff.createOp("replace", ptr);
            op.put("value", second.deepCopy());
            ops.add((JsonNode)op);
            return;
        }
        if (firstType == NodeType.OBJECT) {
            JsonDiff.genObjectDiff(ops, ptr, first, second);
        } else {
            JsonDiff.genArrayDiff(ops, ptr, first, second);
        }
    }

    private static void genObjectDiff(List<JsonNode> ops, JsonPointer ptr, JsonNode first, JsonNode second) {
        HashSet firstKeys = Sets.newHashSet((Iterator)first.fieldNames());
        HashSet secondKeys = Sets.newHashSet((Iterator)second.fieldNames());
        Sets.SetView added = Sets.difference((Set)secondKeys, (Set)firstKeys);
        for (String fieldName : added) {
            ObjectNode op = JsonDiff.createOp("add", ptr.append(fieldName));
            op.put("value", second.get(fieldName).deepCopy());
            ops.add((JsonNode)op);
        }
        Sets.SetView removed = Sets.difference((Set)firstKeys, (Set)secondKeys);
        for (String fieldName : removed) {
            ops.add((JsonNode)JsonDiff.createOp("remove", ptr.append(fieldName)));
        }
        Sets.SetView inCommon = Sets.intersection((Set)firstKeys, (Set)secondKeys);
        for (String fieldName : inCommon) {
            JsonDiff.genDiff(ops, ptr.append(fieldName), first.get(fieldName), second.get(fieldName));
        }
    }

    private static void genArrayDiff(List<JsonNode> ops, JsonPointer ptr, JsonNode first, JsonNode second) {
        int index;
        int firstSize = first.size();
        int secondSize = second.size();
        for (index = firstSize; index < secondSize; ++index) {
            ObjectNode op = JsonDiff.createOp("add", ptr.append("-"));
            op.put("value", second.get(index).deepCopy());
            ops.add((JsonNode)op);
        }
        for (index = firstSize - 1; index >= secondSize; --index) {
            ops.add((JsonNode)JsonDiff.createOp("remove", ptr.append(index)));
        }
        int size = Math.min(firstSize, secondSize);
        for (int index2 = 0; index2 < size; ++index2) {
            JsonDiff.genDiff(ops, ptr.append(index2), first.get(index2), second.get(index2));
        }
    }

    private static ObjectNode createOp(String name, JsonPointer ptr) {
        ObjectNode ret = FACTORY.objectNode();
        ret.put("op", name);
        ret.put("path", ptr.toString());
        return ret;
    }
}

