/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.spring.jdbc.oracle;

import com.github.ferstl.spring.jdbc.oracle.NamedSqlValue;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;

public final class SqlOracleArrayValue
implements NamedSqlValue {
    private final Object[] values;
    private final String typeName;
    private Array array;

    public SqlOracleArrayValue(String typeName, Object ... values) {
        this.values = values;
        this.typeName = typeName;
    }

    public void setValue(PreparedStatement ps, int paramIndex) throws SQLException {
        Array array = this.createArray(ps.getConnection());
        ps.setArray(paramIndex, array);
    }

    @Override
    public void setValue(PreparedStatement ps, String paramName) throws SQLException {
        Array array = this.createArray(ps.getConnection());
        ps.unwrap(OraclePreparedStatement.class).setArrayAtName(paramName, array);
    }

    private Array createArray(Connection conn) throws SQLException {
        if (this.array != null) {
            throw new InvalidDataAccessApiUsageException("Value bound more than once");
        }
        this.array = conn.unwrap(OracleConnection.class).createOracleArray(this.typeName, (Object)this.values);
        return this.array;
    }

    public void cleanup() {
        if (this.array == null) {
            return;
        }
        try {
            this.array.free();
            this.array = null;
        }
        catch (SQLException e) {
            throw new CleanupFailureDataAccessException("could not free array", (Throwable)e);
        }
    }
}

