/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adoptopenjdk.jitwatch.core.JITWatchConstants;
import org.adoptopenjdk.jitwatch.model.IMetaMember;
import org.adoptopenjdk.jitwatch.model.IParseDictionary;
import org.adoptopenjdk.jitwatch.model.IReadOnlyJITDataModel;
import org.adoptopenjdk.jitwatch.model.LogParseException;
import org.adoptopenjdk.jitwatch.model.MemberSignatureParts;
import org.adoptopenjdk.jitwatch.model.MetaClass;
import org.adoptopenjdk.jitwatch.model.PackageManager;
import org.adoptopenjdk.jitwatch.model.Tag;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.util.ClassUtil;
import org.adoptopenjdk.jitwatch.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParseUtil {
    private static final Logger logger = LoggerFactory.getLogger(ParseUtil.class);
    public static String CLASS_NAME_REGEX_GROUP = "([\\p{L}0-9$=_{};\\.\\[/<>]+)";
    public static String METHOD_NAME_REGEX_GROUP = "([^;\\[/]+)";
    public static String PARAM_REGEX_GROUP = "(\\(.*\\))";
    public static String RETURN_REGEX_GROUP = "(.*)";
    private static final Pattern PATTERN_LOG_SIGNATURE = Pattern.compile("^" + CLASS_NAME_REGEX_GROUP + " " + METHOD_NAME_REGEX_GROUP + " " + PARAM_REGEX_GROUP + RETURN_REGEX_GROUP);
    public static final char TYPE_SHORT = 'S';
    public static final char TYPE_CHARACTER = 'C';
    public static final char TYPE_BYTE = 'B';
    public static final char TYPE_VOID = 'V';
    public static final char TYPE_LONG = 'J';
    public static final char TYPE_DOUBLE = 'D';
    public static final char TYPE_BOOLEAN = 'Z';
    public static final char TYPE_INTEGER = 'I';
    public static final char TYPE_FLOAT = 'F';

    private ParseUtil() {
    }

    public static long parseStamp(String stamp) {
        long result = 0L;
        if (stamp != null) {
            double number = ParseUtil.parseLocaleSafeDouble(stamp);
            result = (long)(number * 1000.0);
        } else {
            logger.warn("Could not parse null stamp");
            Thread.dumpStack();
        }
        return result;
    }

    public static long getStamp(Map<String, String> attrs) {
        long result = 0L;
        if (attrs.containsKey("stamp_completed")) {
            result = ParseUtil.parseStamp(attrs.get("stamp_completed"));
        } else if (attrs.containsKey("stamp")) {
            result = ParseUtil.parseStamp(attrs.get("stamp"));
        }
        return result;
    }

    public static double parseLocaleSafeDouble(String str) {
        NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
        double result = 0.0;
        try {
            result = nf.parse(str).doubleValue();
        }
        catch (ParseException pe) {
            logger.warn("Could not parse {} as a Double", (Throwable)pe);
        }
        return result;
    }

    public static Class<?> getPrimitiveClass(char c) {
        switch (c) {
            case 'S': {
                return Short.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'V': {
                return Void.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
        }
        throw new RuntimeException("Unknown class for " + c);
    }

    public static String expandParameterType(String name) {
        StringBuilder builder = new StringBuilder();
        int arrayDepth = 0;
        block12: for (int pos = 0; pos < name.length(); ++pos) {
            char c = name.charAt(pos);
            switch (c) {
                case '[': {
                    ++arrayDepth;
                    continue block12;
                }
                case 'S': {
                    builder.append("short");
                    continue block12;
                }
                case 'C': {
                    builder.append("char");
                    continue block12;
                }
                case 'B': {
                    builder.append("byte");
                    continue block12;
                }
                case 'J': {
                    builder.append("long");
                    continue block12;
                }
                case 'D': {
                    builder.append("double");
                    continue block12;
                }
                case 'Z': {
                    builder.append("boolean");
                    continue block12;
                }
                case 'I': {
                    builder.append("int");
                    continue block12;
                }
                case 'F': {
                    builder.append("float");
                    continue block12;
                }
                case ';': {
                    continue block12;
                }
                default: {
                    if (name.charAt(pos) == 'L' && name.endsWith(";")) {
                        builder.append(name.substring(pos + 1, name.length() - 1));
                        break block12;
                    }
                    builder.append(name.substring(pos));
                    break block12;
                }
            }
        }
        for (int i = 0; i < arrayDepth; ++i) {
            builder.append("[]");
        }
        return builder.toString();
    }

    public static String[] splitLogSignatureWithRegex(String logSignature) throws LogParseException {
        String sig = logSignature;
        Matcher matcher = PATTERN_LOG_SIGNATURE.matcher(sig = StringUtil.replaceXMLEntities(sig));
        if (matcher.find()) {
            String className = matcher.group(1);
            String methodName = matcher.group(2);
            String paramTypes = matcher.group(3).replace("(", "").replace(")", "");
            String returnType = matcher.group(4);
            return new String[]{className, methodName, paramTypes, returnType};
        }
        logger.debug("Could not apply {} to {}", (Object)PATTERN_LOG_SIGNATURE, (Object)logSignature);
        throw new LogParseException("Could not split signature with regex: '" + logSignature + '\'');
    }

    public static IMetaMember findMemberWithSignature(IReadOnlyJITDataModel model, String logSignature) throws LogParseException {
        MemberSignatureParts msp;
        IMetaMember metaMember = null;
        if (logSignature != null && (metaMember = model.findMetaMember(msp = MemberSignatureParts.fromLogCompilationSignature(logSignature))) == null) {
            throw new LogParseException("MetaMember not found for " + logSignature);
        }
        return metaMember;
    }

    public static Class<?>[] getClassTypes(String typesString) throws LogParseException {
        List<Class<?>> classes = null;
        try {
            classes = ParseUtil.findClassesForTypeString(typesString);
        }
        catch (Throwable t) {
            throw new LogParseException("Could not parse types: " + typesString, t);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static Class<?> findClassForLogCompilationParameter(String param) throws ClassNotFoundException {
        StringBuilder builder = new StringBuilder();
        if (ParseUtil.isPrimitive(param)) {
            return ParseUtil.classForPrimitive(param);
        }
        int arrayBracketCount = ParseUtil.getArrayBracketCount(param);
        if (param.contains(">")) {
            param = ParseUtil.stripGenerics(param);
        }
        if (arrayBracketCount == 0) {
            if (param.endsWith("...")) {
                String partBeforeDots = param.substring(0, param.length() - "...".length());
                if (ParseUtil.isPrimitive(partBeforeDots)) {
                    builder.append("<").append(ParseUtil.classForPrimitive(partBeforeDots));
                } else {
                    builder.append("[L").append(partBeforeDots);
                    builder.append(';');
                }
            } else {
                builder.append(param);
            }
        } else {
            int arrayBracketChars = 2 * arrayBracketCount;
            String partBeforeArrayBrackets = param.substring(0, param.length() - arrayBracketChars);
            for (int i = 0; i < arrayBracketCount - 1; ++i) {
                builder.append('[');
            }
            if (ParseUtil.isPrimitive(partBeforeArrayBrackets)) {
                builder.append('[');
                builder.append(ParseUtil.getClassTypeCharForPrimitiveTypeString(partBeforeArrayBrackets));
            } else {
                builder.append("[L");
                builder.append(param);
                builder.delete(builder.length() - arrayBracketChars, builder.length());
                builder.append(';');
            }
        }
        return ClassUtil.loadClassWithoutInitialising(builder.toString());
    }

    public static String stripGenerics(String param) {
        String result = param;
        if (param != null) {
            int firstOpenAngle = param.indexOf(60);
            int lastCloseAngle = param.lastIndexOf(62);
            if (firstOpenAngle != -1 && lastCloseAngle != -1 && firstOpenAngle < lastCloseAngle) {
                result = param.substring(0, firstOpenAngle) + param.substring(lastCloseAngle + 1);
            }
        }
        return result;
    }

    public static boolean paramClassesMatch(boolean memberHasVarArgs, List<Class<?>> memberParamClasses, List<Class<?>> signatureParamClasses, boolean matchTypesExactly) {
        boolean result = true;
        int memberParamCount = memberParamClasses.size();
        int signatureParamCount = signatureParamClasses.size();
        if (!memberHasVarArgs && memberParamCount != signatureParamCount) {
            result = false;
        } else if (memberParamCount > 0 && signatureParamCount > 0) {
            boolean unusedMemberParams;
            int memPos = memberParamCount - 1;
            for (int sigPos = signatureParamCount - 1; sigPos >= 0; --sigPos) {
                boolean isLastParameter;
                Class<?> sigParamClass = signatureParamClasses.get(sigPos);
                Class<?> memParamClass = memberParamClasses.get(memPos);
                boolean memberParamCouldBeVarArgs = false;
                boolean bl = isLastParameter = memPos == memberParamCount - 1;
                if (memberHasVarArgs && isLastParameter) {
                    memberParamCouldBeVarArgs = true;
                }
                boolean classMatch = false;
                classMatch = matchTypesExactly ? memParamClass.equals(sigParamClass) : memParamClass.isAssignableFrom(sigParamClass);
                if (classMatch) {
                    if (memPos > 0) {
                        --memPos;
                        continue;
                    }
                    if (sigPos <= 0) continue;
                    result = false;
                    break;
                }
                if (memberParamCouldBeVarArgs) {
                    Class<?> componentType = memParamClass.getComponentType();
                    if (componentType.isAssignableFrom(sigParamClass)) continue;
                    result = false;
                    break;
                }
                result = false;
                break;
            }
            boolean bl = unusedMemberParams = memPos > 0;
            if (unusedMemberParams) {
                result = false;
            }
        }
        return result;
    }

    public static boolean typeIsVarArgs(String type) {
        return type != null && type.endsWith("...");
    }

    public static char getClassTypeCharForPrimitiveTypeString(String type) {
        switch (type) {
            case "int": {
                return 'I';
            }
            case "boolean": {
                return 'Z';
            }
            case "long": {
                return 'J';
            }
            case "double": {
                return 'D';
            }
            case "float": {
                return 'F';
            }
            case "short": {
                return 'S';
            }
            case "byte": {
                return 'B';
            }
            case "char": {
                return 'C';
            }
            case "void": {
                return 'V';
            }
        }
        throw new RuntimeException(type + " is not a primitive type");
    }

    public static boolean isPrimitive(String type) {
        boolean result = false;
        if (type != null) {
            switch (type) {
                case "int": 
                case "boolean": 
                case "long": 
                case "double": 
                case "float": 
                case "short": 
                case "byte": 
                case "char": 
                case "void": {
                    result = true;
                }
            }
        }
        return result;
    }

    public static Class<?> classForPrimitive(String primitiveType) {
        if (primitiveType != null) {
            switch (primitiveType) {
                case "int": {
                    return Integer.TYPE;
                }
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "long": {
                    return Long.TYPE;
                }
                case "double": {
                    return Double.TYPE;
                }
                case "float": {
                    return Float.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
                case "byte": {
                    return Byte.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
                case "void": {
                    return Void.TYPE;
                }
            }
        }
        throw new RuntimeException(primitiveType + " is not a primitive type");
    }

    public static int getArrayBracketCount(String param) {
        int count = 0;
        if (param != null) {
            int index = param.indexOf("[]", 0);
            while (index != -1) {
                ++count;
                index = param.indexOf("[]", index + 2);
            }
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> parseTypeString(String typesString) {
        result = new ArrayList<String>();
        toParse = typesString.replace('/', '.');
        pos = 0;
        builder = new StringBuilder();
        stringLen = toParse.length();
        block4: while (pos < stringLen) {
            c = toParse.charAt(pos);
            switch (c) {
                case '[': {
                    builder.delete(0, builder.length());
                    builder.append(c);
                    c = toParse.charAt(++pos);
                    while (c == '[') {
                        builder.append(c);
                        c = toParse.charAt(++pos);
                    }
                    if (c != 'L') ** GOTO lbl28
                    while (pos < stringLen) {
                        c = toParse.charAt(pos++);
                        builder.append(c);
                        if (c != ';') continue;
                        ** GOTO lbl31
                    }
                    ** GOTO lbl31
lbl28:
                    // 1 sources

                    builder.append(c);
                    ++pos;
lbl31:
                    // 3 sources

                    result.add(builder.toString());
                    builder.delete(0, builder.length());
                    continue block4;
                }
                case 'L': {
                    while (pos < stringLen - 1) {
                        if ((c = toParse.charAt(++pos)) == ';') {
                            ++pos;
                            break;
                        }
                        builder.append(c);
                    }
                    result.add(builder.toString());
                    builder.delete(0, builder.length());
                    continue block4;
                }
            }
            result.add(Character.toString(c));
            ++pos;
        }
        return result;
    }

    public static List<Class<?>> findClassesForTypeString(String typesString) throws ClassNotFoundException {
        ArrayList result = new ArrayList();
        List<String> typeNames = ParseUtil.parseTypeString(typesString);
        for (String typeName : typeNames) {
            Class<?> clazz = null;
            clazz = typeName.length() == 1 ? ParseUtil.getPrimitiveClass(typeName.charAt(0)) : ClassUtil.loadClassWithoutInitialising(typeName);
            result.add(clazz);
        }
        return result;
    }

    public static String findBestMatchForMemberSignature(IMetaMember member, List<String> lines) {
        int index;
        String match = null;
        logger.debug("findBestMatch: {}", (Object)member.toString());
        if (lines != null && (index = ParseUtil.findBestLineMatchForMemberSignature(member, lines)) > 0 && index < lines.size()) {
            match = lines.get(index);
        }
        return match;
    }

    public static int findBestLineMatchForMemberSignature(IMetaMember member, List<String> lines) {
        int bestScoreLine = 0;
        if (lines != null) {
            String memberName = member.getMemberName();
            int modifier = member.getModifier();
            String returnTypeName = member.getReturnTypeName();
            String[] paramTypeNames = member.getParamTypeNames();
            int bestScore = 0;
            for (int i = 0; i < lines.size(); ++i) {
                List<String> mspParamTypes;
                MemberSignatureParts msp;
                String line = lines.get(i);
                int score = 0;
                if (!line.contains(memberName) || !memberName.equals((msp = MemberSignatureParts.fromBytecodeSignature(member.getMetaClass().getFullyQualifiedName(), line)).getMemberName()) || msp.getModifier() != modifier || (mspParamTypes = msp.getParamTypes()).size() != paramTypeNames.length) continue;
                int pos = 0;
                for (String memberParamType : paramTypeNames) {
                    String mspParamType = msp.getParamTypes().get(pos++);
                    if (!ParseUtil.compareTypeEquality(memberParamType, mspParamType, msp.getGenerics())) continue;
                    ++score;
                }
                if (ParseUtil.compareTypeEquality(returnTypeName, msp.getReturnType(), msp.getGenerics())) {
                    ++score;
                }
                if (score <= bestScore) continue;
                bestScoreLine = i;
                bestScore = score;
            }
        }
        return bestScoreLine;
    }

    private static boolean compareTypeEquality(String memberTypeName, String inMspTypeName, Map<String, String> genericsMap) {
        String mspTypeNameWithoutArray;
        String genericSubstitution;
        String mspTypeName = inMspTypeName;
        if (memberTypeName != null && memberTypeName.equals(mspTypeName)) {
            return true;
        }
        if (mspTypeName != null && (genericSubstitution = genericsMap.get(mspTypeNameWithoutArray = ParseUtil.getParamTypeWithoutArrayBrackets(mspTypeName))) != null) {
            mspTypeName = mspTypeName.replace(mspTypeNameWithoutArray, genericSubstitution);
            if (memberTypeName != null && memberTypeName.equals(mspTypeName)) {
                return true;
            }
        }
        return false;
    }

    public static String getParamTypeWithoutArrayBrackets(String paramType) {
        int bracketsIndex = paramType.indexOf("[]");
        if (bracketsIndex != -1) {
            return paramType.substring(0, bracketsIndex);
        }
        return paramType;
    }

    public static String getMethodTagReturn(Tag methodTag, IParseDictionary parseDictionary) {
        String returnTypeId = methodTag.getAttribute("return");
        String returnType = ParseUtil.lookupType(returnTypeId, parseDictionary);
        return returnType;
    }

    public static List<String> getMethodTagArguments(Tag methodTag, IParseDictionary parseDictionary) {
        ArrayList<String> result = new ArrayList<String>();
        String argumentsTypeId = methodTag.getAttribute("arguments");
        if (argumentsTypeId != null) {
            String[] typeIDs;
            for (String typeID : typeIDs = argumentsTypeId.split(" ")) {
                result.add(ParseUtil.lookupType(typeID, parseDictionary));
            }
        }
        return result;
    }

    public static String getMethodName(String methodID, IParseDictionary parseDictionary) {
        String result = null;
        Tag methodTag = parseDictionary.getMethod(methodID);
        if (methodTag != null) {
            String methodName = methodTag.getAttribute("name");
            result = StringUtil.replaceXMLEntities(methodName);
        }
        return result;
    }

    public static IMetaMember lookupMember(String methodId, IParseDictionary parseDictionary, IReadOnlyJITDataModel model) {
        IMetaMember result = null;
        Tag methodTag = parseDictionary.getMethod(methodId);
        if (methodTag != null) {
            String methodName = methodTag.getAttribute("name");
            methodName = StringUtil.replaceXMLEntities(methodName);
            String klassId = methodTag.getAttribute("holder");
            Tag klassTag = parseDictionary.getKlass(klassId);
            String metaClassName = klassTag.getAttribute("name");
            metaClassName = metaClassName.replace("/", ".");
            String returnType = ParseUtil.getMethodTagReturn(methodTag, parseDictionary);
            List<String> argumentTypes = ParseUtil.getMethodTagArguments(methodTag, parseDictionary);
            PackageManager pm = model.getPackageManager();
            MetaClass metaClass = pm.getMetaClass(metaClassName);
            if (metaClass == null) {
                Class<?> clazz = null;
                try {
                    clazz = ClassUtil.loadClassWithoutInitialising(metaClassName);
                    if (clazz != null) {
                        metaClass = model.buildAndGetMetaClass(clazz);
                    }
                }
                catch (ClassNotFoundException cnf) {
                    if (!ParseUtil.possibleLambdaMethod(metaClassName)) {
                        logger.error("ClassNotFoundException: '" + metaClassName + '\'');
                    }
                }
                catch (NoClassDefFoundError ncdf) {
                    logger.error("NoClassDefFoundError: '" + metaClassName + ' ' + ncdf.getMessage() + '\'');
                }
            }
            if (metaClass != null) {
                MemberSignatureParts msp = MemberSignatureParts.fromParts(metaClass.getFullyQualifiedName(), methodName, returnType, argumentTypes);
                result = metaClass.getMemberForSignature(msp);
            } else if (!ParseUtil.possibleLambdaMethod(metaClassName)) {
                logger.error("metaClass not found: {}", (Object)metaClassName);
            }
        }
        return result;
    }

    public static boolean possibleLambdaMethod(String fqClassName) {
        if (fqClassName.contains("$$Lambda")) {
            return true;
        }
        for (String prefix : JITWatchConstants.getAutoGeneratedClassPrefixes()) {
            if (!fqClassName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String lookupType(String typeOrKlassID, IParseDictionary parseDictionary) {
        String result = null;
        if (typeOrKlassID != null) {
            String typeAttrName;
            Tag typeTag = parseDictionary.getType(typeOrKlassID);
            if (typeTag == null) {
                typeTag = parseDictionary.getKlass(typeOrKlassID);
            }
            if (typeTag != null && (typeAttrName = typeTag.getAttribute("name")) != null) {
                result = typeAttrName.replace("/", ".");
            }
        }
        return result;
    }

    public static String getPackageFromSource(String source) {
        String[] lines;
        String result = null;
        for (String line : lines = source.split("\n")) {
            if (!(line = line.trim()).startsWith("package") || !line.endsWith(";")) continue;
            result = line.substring("package".length(), line.length() - 1).trim();
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static String getClassFromSource(String source) {
        String result = null;
        String[] lines = source.split("\n");
        String classToken = " class ";
        for (String line : lines) {
            int classTokenPos = (line = line.trim()).indexOf(classToken);
            if (classTokenPos == -1) continue;
            result = line.substring(classTokenPos + classToken.length());
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static String bytecodeMethodCommentToReadableString(String className, String comment) {
        StringBuilder builder = new StringBuilder();
        if (ParseUtil.bytecodeMethodCommentHasNoClassPrefix(comment)) {
            comment = className.replace(".", "/") + '.' + comment;
        }
        String logCompilationSignature = ParseUtil.bytecodeCommentSignatureToLogCompilationSignature(comment);
        try {
            String[] parts = ParseUtil.splitLogSignatureWithRegex(logCompilationSignature);
            String fullyQualifiedClassName = parts[0];
            String memberName = parts[1];
            String paramTypes = parts[2];
            builder.append(fullyQualifiedClassName).append(".");
            builder.append(memberName).append("(");
            List<String> paramTypeNames = ParseUtil.parseTypeString(paramTypes);
            if (paramTypeNames.size() > 0) {
                for (String paramTypeName : paramTypeNames) {
                    builder.append(ParseUtil.expandParameterType(paramTypeName));
                    builder.append(',');
                }
                builder.deleteCharAt(builder.length() - 1);
            }
            builder.append(")");
        }
        catch (LogParseException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static boolean bytecodeMethodCommentHasNoClassPrefix(String comment) {
        return comment.indexOf(46) == -1;
    }

    private static String prependCurrentMember(String comment, IMetaMember member) {
        String currentClass = member.getMetaClass().getFullyQualifiedName();
        currentClass = currentClass.replace('.', '/');
        return currentClass + '.' + comment;
    }

    public static String bytecodeCommentSignatureToLogCompilationSignature(String bytcodeCommentSignature) {
        return bytcodeCommentSignature.replace('.', ' ').replace(':', ' ').replace('/', '.').replace("\"", "");
    }

    public static IMetaMember getMemberFromBytecodeComment(IReadOnlyJITDataModel model, IMetaMember currentMember, BytecodeInstruction instruction) throws LogParseException {
        String comment;
        IMetaMember result = null;
        if (instruction != null && (comment = instruction.getCommentWithMemberPrefixStripped()) != null) {
            if (ParseUtil.bytecodeMethodCommentHasNoClassPrefix(comment) && currentMember != null) {
                comment = ParseUtil.prependCurrentMember(comment, currentMember);
            }
            MemberSignatureParts msp = MemberSignatureParts.fromBytecodeComment(comment);
            result = model.findMetaMember(msp);
        }
        return result;
    }
}

