/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.optimizedvcall;

import org.adoptopenjdk.jitwatch.model.IMetaMember;
import org.adoptopenjdk.jitwatch.model.bytecode.BytecodeInstruction;
import org.adoptopenjdk.jitwatch.optimizedvcall.VirtualCallSite;

public class OptimizedVirtualCall {
    private IMetaMember callerMember;
    private IMetaMember calleeMember;
    private VirtualCallSite callsite;
    private BytecodeInstruction bytecodeInstruction;

    public OptimizedVirtualCall(IMetaMember callerMember, IMetaMember calleeMember, VirtualCallSite callsite, BytecodeInstruction bytecodeInstruction) {
        this.callerMember = callerMember;
        this.calleeMember = calleeMember;
        this.callsite = callsite;
        this.bytecodeInstruction = bytecodeInstruction;
    }

    public IMetaMember getCallerMember() {
        return this.callerMember;
    }

    public IMetaMember getCalleeMember() {
        return this.calleeMember;
    }

    public VirtualCallSite getCallsite() {
        return this.callsite;
    }

    public BytecodeInstruction getBytecodeInstruction() {
        return this.bytecodeInstruction;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bytecodeInstruction == null ? 0 : this.bytecodeInstruction.hashCode());
        result = 31 * result + (this.calleeMember == null ? 0 : this.calleeMember.hashCode());
        result = 31 * result + (this.callerMember == null ? 0 : this.callerMember.hashCode());
        result = 31 * result + (this.callsite == null ? 0 : this.callsite.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OptimizedVirtualCall other = (OptimizedVirtualCall)obj;
        if (this.bytecodeInstruction == null ? other.bytecodeInstruction != null : !this.bytecodeInstruction.equals(other.bytecodeInstruction)) {
            return false;
        }
        if (this.calleeMember == null ? other.calleeMember != null : !this.calleeMember.equals(other.calleeMember)) {
            return false;
        }
        if (this.callerMember == null ? other.callerMember != null : !this.callerMember.equals(other.callerMember)) {
            return false;
        }
        return !(this.callsite == null ? other.callsite != null : !this.callsite.equals(other.callsite));
    }

    public String toString() {
        return "OptimizedVirtualCall [callerMember=" + this.callerMember + ", calleeMember=" + this.calleeMember + ", callsite=" + this.callsite + ", bytecodeInstruction=" + this.bytecodeInstruction + "]";
    }
}

