/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.bytecode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adoptopenjdk.jitwatch.model.bytecode.ClassBC;
import org.adoptopenjdk.jitwatch.model.bytecode.LineTable;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceMapper {
    private static final Logger logger = LoggerFactory.getLogger(SourceMapper.class);
    private static Map<String, List<ClassBC>> sourceToClassMap = new HashMap<String, List<ClassBC>>();

    public static void clear() {
        sourceToClassMap.clear();
    }

    private static String getFullyQualifiedSourceName(ClassBC classBytecode) {
        StringBuilder builder = new StringBuilder();
        String packageName = classBytecode.getPackageName();
        if (packageName != null && packageName.length() > 0) {
            builder.append(packageName).append(".");
        }
        builder.append(classBytecode.getSourceFile());
        return builder.toString();
    }

    public static void addSourceClassMapping(ClassBC classBytecode) {
        String fqName = SourceMapper.getFullyQualifiedSourceName(classBytecode);
        List<ClassBC> classBytecodeList = sourceToClassMap.get(fqName);
        if (classBytecodeList == null) {
            classBytecodeList = new ArrayList<ClassBC>();
            sourceToClassMap.put(fqName, classBytecodeList);
        }
        classBytecodeList.add(classBytecode);
    }

    public static List<ClassBC> getClassBytecodeList(ClassBC classBytecode) {
        String fqName = SourceMapper.getFullyQualifiedSourceName(classBytecode);
        List<ClassBC> result = sourceToClassMap.get(fqName);
        if (result == null) {
            result = new ArrayList<ClassBC>();
        }
        return Collections.unmodifiableList(result);
    }

    public static MemberBytecode getMemberBytecodeForSourceLine(ClassBC classBytecode, int sourceLine) {
        MemberBytecode result;
        block4: {
            result = null;
            String fqName = SourceMapper.getFullyQualifiedSourceName(classBytecode);
            List<ClassBC> classBytecodeList = sourceToClassMap.get(fqName);
            if (classBytecodeList != null) {
                for (ClassBC classBC : classBytecodeList) {
                    for (MemberBytecode tempMemberBytecode : classBC.getMemberBytecodeList()) {
                        LineTable lineTable = tempMemberBytecode.getLineTable();
                        if (!lineTable.sourceLineInRange(sourceLine)) continue;
                        result = tempMemberBytecode;
                        break block4;
                    }
                }
            } else {
                logger.warn("No bytecode found for source {}", (Object)fqName);
            }
        }
        return result;
    }

    public static int getSourceLineFromBytecode(MemberBytecode memberBytecode, int bytecodeOffset) {
        int result = -1;
        if (memberBytecode != null) {
            LineTable lineTable = memberBytecode.getLineTable();
            result = lineTable.findSourceLineForBytecodeOffset(bytecodeOffset);
        }
        return result;
    }
}

