/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.bytecode;

public class LineTableEntry {
    private int sourceOffset;
    private int bytecodeOffset;

    public LineTableEntry(int sourceOffset, int bytecodeOffset) {
        this.sourceOffset = sourceOffset;
        this.bytecodeOffset = bytecodeOffset;
    }

    public int getSourceOffset() {
        return this.sourceOffset;
    }

    public int getBytecodeOffset() {
        return this.bytecodeOffset;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.sourceOffset).append(' ').append(':').append(' ');
        builder.append(this.bytecodeOffset);
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bytecodeOffset;
        result = 31 * result + this.sourceOffset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineTableEntry other = (LineTableEntry)obj;
        if (this.bytecodeOffset != other.bytecodeOffset) {
            return false;
        }
        return this.sourceOffset == other.sourceOffset;
    }
}

