/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.bytecode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.adoptopenjdk.jitwatch.model.bytecode.LineTableEntry;
import org.adoptopenjdk.jitwatch.model.bytecode.MemberBytecode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineTable {
    private List<LineTableEntry> lineTableEntries = new ArrayList<LineTableEntry>();
    private static final Logger logger = LoggerFactory.getLogger(LineTable.class);
    private MemberBytecode memberBytecode;

    public LineTable(MemberBytecode memberBytecode) {
        this.memberBytecode = memberBytecode;
    }

    public MemberBytecode getMemberBytecode() {
        return this.memberBytecode;
    }

    public void add(LineTableEntry entry) {
        this.lineTableEntries.add(entry);
        this.sort();
    }

    public void add(LineTable lineTable) {
        if (lineTable != null) {
            this.lineTableEntries.addAll(lineTable.lineTableEntries);
            this.sort();
        }
    }

    public int getLastSourceLine() {
        return this.lineTableEntries.get(this.lineTableEntries.size() - 1).getSourceOffset();
    }

    public boolean sourceLineInRange(int sourceLine) {
        boolean result = false;
        if (this.lineTableEntries.size() > 0) {
            int maxIndex = this.lineTableEntries.size() - 1;
            int minSourceLine = this.lineTableEntries.get(0).getSourceOffset();
            int maxSourceLine = this.lineTableEntries.get(maxIndex).getSourceOffset();
            result = sourceLine >= minSourceLine && sourceLine <= maxSourceLine;
        }
        return result;
    }

    private void sort() {
        Collections.sort(this.lineTableEntries, new Comparator<LineTableEntry>(){

            @Override
            public int compare(LineTableEntry o1, LineTableEntry o2) {
                return Integer.compare(o1.getSourceOffset(), o2.getSourceOffset());
            }
        });
    }

    public LineTableEntry getEntryForSourceLine(int sourceLine) {
        LineTableEntry result = null;
        for (LineTableEntry entry : this.lineTableEntries) {
            if (entry.getSourceOffset() != sourceLine) continue;
            result = entry;
            break;
        }
        return result;
    }

    public List<LineTableEntry> getEntries() {
        return Collections.unmodifiableList(this.lineTableEntries);
    }

    public int findSourceLineForBytecodeOffset(int searchBCI) {
        int sourceAtClosestBCI = -1;
        int distanceToClosestBCI = Integer.MAX_VALUE;
        for (LineTableEntry entry : this.lineTableEntries) {
            int entryBCI = entry.getBytecodeOffset();
            int distance = searchBCI - entryBCI;
            if (distance < 0) continue;
            if (distance == 0) {
                sourceAtClosestBCI = entry.getSourceOffset();
                break;
            }
            if (distance >= distanceToClosestBCI) continue;
            distanceToClosestBCI = distance;
            sourceAtClosestBCI = entry.getSourceOffset();
        }
        return sourceAtClosestBCI;
    }

    public int size() {
        return this.lineTableEntries.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (LineTableEntry entry : this.lineTableEntries) {
            builder.append(entry).append('\n');
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lineTableEntries == null ? 0 : this.lineTableEntries.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineTable other = (LineTable)obj;
        return !(this.lineTableEntries == null ? other.lineTableEntries != null : !this.lineTableEntries.equals(other.lineTableEntries));
    }
}

