/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.assembly;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AssemblyReference {
    private static Map<String, String> mnemonicMap = new HashMap<String, String>();
    private static final String TAG_MNEM_OPEN = "<mnem>";
    private static final String TAG_MNEM_CLOSE = "</mnem>";
    private static final String TAG_BRIEF_OPEN = "<brief>";
    private static final String TAG_BRIEF_CLOSE = "</brief>";
    private static final Logger LOGGER = LoggerFactory.getLogger(AssemblyReference.class);
    private static final String ASM_REF_PATH = "/x86reference.xml";

    private AssemblyReference() {
    }

    public static String lookupMnemonic(String mnemonic) {
        String result = mnemonicMap.get(mnemonic);
        if (result == null && (mnemonic.endsWith("b") || mnemonic.endsWith("w") || mnemonic.endsWith("l") || mnemonic.endsWith("q"))) {
            result = mnemonicMap.get(mnemonic.substring(0, mnemonic.length() - 1));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        BufferedReader bufferedReader = null;
        try {
            InputStream asmRefInputStream = AssemblyReference.class.getResourceAsStream(ASM_REF_PATH);
            if (asmRefInputStream == null) {
                LOGGER.error("Could not find assembly reference {}. If launching from an IDE please add /src/main/resources to your classpath", (Object)ASM_REF_PATH);
            } else {
                bufferedReader = new BufferedReader(new InputStreamReader(asmRefInputStream), 65536);
                String currentLine = bufferedReader.readLine();
                HashSet<String> mnemonics = new HashSet<String>();
                while (currentLine != null) {
                    int closeBriefPos;
                    int openBriefPos;
                    int closeMnemPos;
                    int openMnemPos = currentLine.indexOf(TAG_MNEM_OPEN);
                    if (openMnemPos != -1 && (closeMnemPos = currentLine.indexOf(TAG_MNEM_CLOSE)) != -1) {
                        String mnemonic = currentLine.substring(openMnemPos + TAG_MNEM_OPEN.length(), closeMnemPos).toLowerCase();
                        mnemonics.add(mnemonic);
                    }
                    if ((openBriefPos = currentLine.indexOf(TAG_BRIEF_OPEN)) != -1 && (closeBriefPos = currentLine.indexOf(TAG_BRIEF_CLOSE)) != -1) {
                        String brief = currentLine.substring(openBriefPos + TAG_BRIEF_OPEN.length(), closeBriefPos);
                        for (String mnemonic : mnemonics) {
                            if (mnemonicMap.containsKey(mnemonic)) continue;
                            mnemonicMap.put(mnemonic, brief);
                        }
                        mnemonics.clear();
                    }
                    currentLine = bufferedReader.readLine();
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Could not load assembly reference", (Throwable)ioe);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ioe) {
                    LOGGER.error("Could not close reader", (Throwable)ioe);
                }
            }
        }
        mnemonicMap.put("movabs", "Move a 64-bit value");
        mnemonicMap.put("ret", mnemonicMap.get("retn"));
        mnemonicMap.put("movslq", mnemonicMap.get("movsxd"));
    }
}

