/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model.assembly;

import java.util.ArrayList;
import java.util.List;
import org.adoptopenjdk.jitwatch.model.assembly.AssemblyInstruction;
import org.adoptopenjdk.jitwatch.util.StringUtil;

public class AssemblyBlock {
    private String title;
    private List<AssemblyInstruction> instructions = new ArrayList<AssemblyInstruction>();

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void addInstruction(AssemblyInstruction instr) {
        this.instructions.add(instr);
    }

    public void replaceLastInstruction(AssemblyInstruction instr) {
        this.instructions.set(this.instructions.size() - 1, instr);
    }

    public List<AssemblyInstruction> getInstructions() {
        return this.instructions;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int maxAnnotationWidth) {
        StringBuilder builder = new StringBuilder();
        if (this.title != null) {
            builder.append(StringUtil.repeat(' ', maxAnnotationWidth));
            builder.append(this.title).append("\n");
        }
        for (AssemblyInstruction instruction : this.instructions) {
            builder.append(instruction.toString(maxAnnotationWidth, false)).append("\n");
        }
        return builder.toString();
    }
}

