/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.adoptopenjdk.jitwatch.model.NumberedLine;

public class SplitLog {
    private List<NumberedLine> headerLines = new ArrayList<NumberedLine>();
    private List<NumberedLine> classLoaderLines = new ArrayList<NumberedLine>();
    private List<NumberedLine> logCompilationLines = new ArrayList<NumberedLine>();
    private List<NumberedLine> assemblyLines = new ArrayList<NumberedLine>();

    public void clear() {
        this.headerLines.clear();
        this.classLoaderLines.clear();
        this.logCompilationLines.clear();
        this.assemblyLines.clear();
    }

    public void addHeaderLine(NumberedLine line) {
        this.headerLines.add(line);
    }

    public void addClassLoaderLine(NumberedLine line) {
        this.classLoaderLines.add(line);
    }

    public void addLogCompilationLine(NumberedLine line) {
        this.logCompilationLines.add(line);
    }

    public void addAssemblyLine(NumberedLine line) {
        this.assemblyLines.add(line);
    }

    public List<NumberedLine> getHeaderLines() {
        return Collections.unmodifiableList(this.headerLines);
    }

    public List<NumberedLine> getClassLoaderLines() {
        return Collections.unmodifiableList(this.classLoaderLines);
    }

    public List<NumberedLine> getLogCompilationLines() {
        return Collections.unmodifiableList(this.logCompilationLines);
    }

    public List<NumberedLine> getAssemblyLines() {
        return Collections.unmodifiableList(this.assemblyLines);
    }
}

