/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.adoptopenjdk.jitwatch.model.AbstractMetaMember;
import org.adoptopenjdk.jitwatch.model.MetaClass;
import org.adoptopenjdk.jitwatch.util.StringUtil;

public class MetaConstructor
extends AbstractMetaMember {
    private String constructorToString;

    public MetaConstructor(Constructor<?> constructor, MetaClass methodClass) {
        super(StringUtil.getUnqualifiedMemberName(constructor.getName()));
        this.constructorToString = constructor.toString();
        this.metaClass = methodClass;
        this.returnType = Void.TYPE;
        this.paramTypes = Arrays.asList(constructor.getParameterTypes());
        this.modifier = constructor.getModifiers();
    }

    public String toString() {
        String methodSigWithoutThrows = this.constructorToString;
        int closingParentheses = methodSigWithoutThrows.indexOf(")");
        if (closingParentheses != methodSigWithoutThrows.length() - 1) {
            methodSigWithoutThrows = methodSigWithoutThrows.substring(0, closingParentheses + 1);
        }
        return methodSigWithoutThrows;
    }
}

