/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.adoptopenjdk.jitwatch.loader.BytecodeLoader;
import org.adoptopenjdk.jitwatch.model.IMetaMember;
import org.adoptopenjdk.jitwatch.model.IReadOnlyJITDataModel;
import org.adoptopenjdk.jitwatch.model.MemberSignatureParts;
import org.adoptopenjdk.jitwatch.model.MetaConstructor;
import org.adoptopenjdk.jitwatch.model.MetaMethod;
import org.adoptopenjdk.jitwatch.model.MetaPackage;
import org.adoptopenjdk.jitwatch.model.bytecode.ClassBC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaClass
implements Comparable<MetaClass> {
    private String className;
    private MetaPackage classPackage;
    private boolean isInterface = false;
    private boolean missingDef = false;
    private List<MetaMethod> classMethods = new CopyOnWriteArrayList<MetaMethod>();
    private List<MetaConstructor> classConstructors = new CopyOnWriteArrayList<MetaConstructor>();
    private int compiledMethodCount = 0;
    private ClassBC classBytecode = null;
    private static final Logger logger = LoggerFactory.getLogger(MetaClass.class);

    public MetaClass(MetaPackage classPackage, String className) {
        this.classPackage = classPackage;
        this.className = className;
    }

    public IMetaMember getFirstConstructor() {
        IMetaMember result = null;
        for (IMetaMember member : this.getMetaMembers()) {
            if (!(member instanceof MetaConstructor)) continue;
            result = member;
            break;
        }
        return result;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void incCompiledMethodCount() {
        ++this.compiledMethodCount;
    }

    public boolean hasCompiledMethods() {
        return this.compiledMethodCount > 0;
    }

    public void setInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    public boolean isMissingDef() {
        return this.missingDef;
    }

    public void setMissingDef(boolean missingDef) {
        this.missingDef = missingDef;
    }

    public ClassBC getClassBytecode(IReadOnlyJITDataModel model, List<String> classLocations) {
        if (this.classBytecode == null) {
            this.classBytecode = BytecodeLoader.fetchBytecodeForClass(classLocations, this.getFullyQualifiedName(), true);
            if (this.classBytecode != null) {
                this.loadInnerClasses(this.classBytecode.getInnerClassNames(), model, classLocations);
            }
        }
        return this.classBytecode;
    }

    public ClassBC getClassBytecode() {
        return this.classBytecode;
    }

    private void loadInnerClasses(List<String> innerClassNames, IReadOnlyJITDataModel model, List<String> classLocations) {
        for (String innerClassName : innerClassNames) {
            MetaClass metaClassForInner = model.getPackageManager().getMetaClass(innerClassName);
            if (metaClassForInner != null) {
                metaClassForInner.getClassBytecode(model, classLocations);
                continue;
            }
            logger.warn("No MetaClass found for inner Class {}", (Object)innerClassName);
        }
    }

    public String toStringDetailed() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.classPackage.getName()).append(".").append(this.className).append(' ').append(this.compiledMethodCount).append("/").append(this.classMethods.size());
        return builder.toString();
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.className;
    }

    public String getFullyQualifiedName() {
        StringBuilder builder = new StringBuilder();
        if (this.classPackage != null && this.classPackage.getName().length() > 0) {
            builder.append(this.classPackage.getName()).append('.');
        }
        builder.append(this.className);
        return builder.toString();
    }

    public String getAbbreviatedFullyQualifiedName() {
        StringBuilder builder = new StringBuilder();
        if (this.classPackage != null && this.classPackage.getName().length() > 0) {
            String[] parts;
            for (String part : parts = this.classPackage.getName().split("\\.")) {
                builder.append(part.charAt(0)).append('.');
            }
        }
        builder.append(this.className);
        return builder.toString();
    }

    public MetaPackage getPackage() {
        return this.classPackage;
    }

    public void addMetaMethod(MetaMethod method) {
        this.classMethods.add(method);
    }

    public void addMetaConstructor(MetaConstructor constructor) {
        this.classConstructors.add(constructor);
    }

    public List<IMetaMember> getMetaMembers() {
        ArrayList<IMetaMember> result = new ArrayList<IMetaMember>();
        Object[] constructorsArray = this.classConstructors.toArray(new MetaConstructor[this.classConstructors.size()]);
        Arrays.sort(constructorsArray);
        Object[] methodsArray = this.classMethods.toArray(new MetaMethod[this.classMethods.size()]);
        Arrays.sort(methodsArray);
        result.addAll(Arrays.asList(constructorsArray));
        result.addAll(Arrays.asList(methodsArray));
        return result;
    }

    public IMetaMember getMemberForSignature(MemberSignatureParts msp) {
        IMetaMember result = null;
        for (IMetaMember member : this.getMetaMembers()) {
            if (!member.matchesSignature(msp, true)) continue;
            result = member;
            break;
        }
        return result;
    }

    public List<String> getTreePath() {
        MetaPackage metaPackage = this.getPackage();
        List<String> path = metaPackage.getPackageComponents();
        path.add(this.getName());
        return path;
    }

    @Override
    public int compareTo(MetaClass other) {
        return this.getName().compareTo(other.getName());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

