/*
 * Decompiled with CFR 0.152.
 */
package org.adoptopenjdk.jitwatch.model;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adoptopenjdk.jitwatch.core.JITWatchConstants;
import org.adoptopenjdk.jitwatch.model.IMetaMember;
import org.adoptopenjdk.jitwatch.model.IReadOnlyJITDataModel;
import org.adoptopenjdk.jitwatch.model.JITEvent;
import org.adoptopenjdk.jitwatch.model.JITStats;
import org.adoptopenjdk.jitwatch.model.Journal;
import org.adoptopenjdk.jitwatch.model.MemberSignatureParts;
import org.adoptopenjdk.jitwatch.model.MetaClass;
import org.adoptopenjdk.jitwatch.model.MetaConstructor;
import org.adoptopenjdk.jitwatch.model.MetaMethod;
import org.adoptopenjdk.jitwatch.model.MetaPackage;
import org.adoptopenjdk.jitwatch.model.PackageManager;
import org.adoptopenjdk.jitwatch.model.Tag;
import org.adoptopenjdk.jitwatch.util.ParseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JITDataModel
implements IReadOnlyJITDataModel {
    private static final Logger logger = LoggerFactory.getLogger(JITDataModel.class);
    private PackageManager pm;
    private JITStats stats;
    private List<JITEvent> jitEvents = new ArrayList<JITEvent>();
    private Map<String, Journal> journalMap = new HashMap<String, Journal>();
    private List<Tag> codeCacheTagList = new ArrayList<Tag>();
    private String vmVersionRelease;

    public JITDataModel() {
        this.pm = new PackageManager();
        this.stats = new JITStats();
    }

    public void setVmVersionRelease(String release) {
        this.vmVersionRelease = release;
    }

    @Override
    public String getVmVersionRelease() {
        return this.vmVersionRelease;
    }

    public void reset() {
        this.pm.clear();
        this.stats.reset();
        this.jitEvents.clear();
        this.journalMap.clear();
        this.codeCacheTagList.clear();
    }

    @Override
    public PackageManager getPackageManager() {
        return this.pm;
    }

    @Override
    public JITStats getJITStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(JITEvent event) {
        List<JITEvent> list = this.jitEvents;
        synchronized (list) {
            this.jitEvents.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JITEvent> getEventListCopy() {
        List<JITEvent> list = this.jitEvents;
        synchronized (list) {
            return new ArrayList<JITEvent>(this.jitEvents);
        }
    }

    public void addNativeBytes(long count) {
        this.stats.addNativeBytes(count);
    }

    public void updateStats(IMetaMember member) {
        String compileKind;
        String fullSignature = member.toString();
        for (String modifier : JITWatchConstants.MODIFIERS) {
            if (!fullSignature.contains(modifier + " ")) continue;
            String incMethodName = "incCount" + modifier.substring(0, 1).toUpperCase() + modifier.substring(1);
            try {
                MethodType mt = MethodType.methodType(Void.TYPE);
                MethodHandle mh = MethodHandles.lookup().findVirtual(JITStats.class, incMethodName, mt);
                mh.invokeExact(this.stats);
            }
            catch (Throwable t) {
                logger.error("Exception: {}", (Object)t.getMessage(), (Object)t);
            }
        }
        String compiler = member.getCompiledAttribute("compiler");
        if (compiler != null) {
            if ("C1".equalsIgnoreCase(compiler)) {
                this.stats.incCountC1();
            } else if ("C2".equalsIgnoreCase(compiler)) {
                this.stats.incCountC2();
            }
        }
        if ((compileKind = member.getCompiledAttribute("compile_kind")) != null) {
            if ("osr".equalsIgnoreCase(compileKind)) {
                this.stats.incCountOSR();
            } else if ("c2n".equalsIgnoreCase(compileKind)) {
                this.stats.incCountC2N();
            }
        }
        long queueStamp = ParseUtil.getStamp(member.getQueuedAttributes());
        long compileStamp = ParseUtil.getStamp(member.getCompiledAttributes());
        if (queueStamp != 0L && compileStamp != 0L) {
            long delayMillis = compileStamp - queueStamp;
            member.addCompiledAttribute("compileMillis", Long.toString(delayMillis));
            this.stats.recordDelay(delayMillis);
        }
    }

    @Override
    public IMetaMember findMetaMember(MemberSignatureParts msp) {
        MetaClass metaClass = this.pm.getMetaClass(msp.getFullyQualifiedClassName());
        IMetaMember result = null;
        if (metaClass != null) {
            List<IMetaMember> metaList = metaClass.getMetaMembers();
            for (IMetaMember member : metaList) {
                if (!member.matchesSignature(msp, true)) continue;
                result = member;
                break;
            }
        }
        return result;
    }

    @Override
    public MetaClass buildAndGetMetaClass(Class<?> clazz) {
        String className;
        String packageName;
        MetaClass resultMetaClass = null;
        String fqClassName = clazz.getName();
        int lastDotIndex = fqClassName.lastIndexOf(46);
        if (lastDotIndex != -1) {
            packageName = fqClassName.substring(0, lastDotIndex);
            className = fqClassName.substring(lastDotIndex + 1);
        } else {
            packageName = "";
            className = fqClassName;
        }
        MetaPackage mp = this.pm.getMetaPackage(packageName);
        if (mp == null) {
            mp = this.pm.buildPackage(packageName);
        }
        resultMetaClass = new MetaClass(mp, className);
        this.pm.addMetaClass(resultMetaClass);
        mp.addClass(resultMetaClass);
        this.stats.incCountClass();
        if (clazz.isInterface()) {
            resultMetaClass.setInterface(true);
        }
        try {
            for (Method method : clazz.getDeclaredMethods()) {
                MetaMethod metaMethod = new MetaMethod(method, resultMetaClass);
                resultMetaClass.addMetaMethod(metaMethod);
                this.stats.incCountMethod();
            }
            for (Executable executable : clazz.getDeclaredConstructors()) {
                MetaConstructor metaConstructor = new MetaConstructor((Constructor<?>)executable, resultMetaClass);
                resultMetaClass.addMetaConstructor(metaConstructor);
                this.stats.incCountConstructor();
            }
        }
        catch (NoClassDefFoundError ncdfe) {
            logger.warn("NoClassDefFoundError: '{}' while building class {}", (Object)ncdfe.getMessage(), (Object)fqClassName);
            throw ncdfe;
        }
        catch (Throwable t) {
            logger.error("Something unexpected happened building meta class {}", (Object)fqClassName, (Object)t);
        }
        return resultMetaClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCodeCacheTag(Tag tag) {
        List<Tag> list = this.codeCacheTagList;
        synchronized (list) {
            this.codeCacheTagList.add(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Tag> getCodeCacheTags() {
        List<Tag> list = this.codeCacheTagList;
        synchronized (list) {
            return new ArrayList<Tag>(this.codeCacheTagList);
        }
    }
}

